<?php

class slToolsDownload
{
    private $url = '';
    private $info = [];
    private $fileName = '';
    private $contentType = '';

    public function __construct(string $url)
    {
        $this->setUrl($url);
    }

    public function setUrl(string $url)
    {
        $this->url = $url;
        $this->info = [];
        $this->fileName = '';
        $this->contentType = '';
    }

    public function getUrl()
    {
        return $this->url;
    }

    public function getInfo()
    {
        if(empty($this->info)){
            $context = stream_context_create(array('ssl' => array(
                'verify_host' => false,
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true,
                'http' => array(
                    'header'=>"Do-Not-Track: true\r\n"
                )
            )));
            $this->info = get_headers($this->url, true, $context);
        }
        
        return $this->info;
    }

    function getFileName() 
    {
        if(!$this->fileName){
            $contentDisposition = $this->getInfo()['Content-Disposition'];
            if (preg_match('/.*?filename="(.+?)"/', $contentDisposition, $matches)) {
                $this->fileName = $matches[1];
            }
            if (!$this->fileName && preg_match('/.*?filename=([^; ]+)/', $contentDisposition, $matches)) {
                $this->fileName = rawurldecode($matches[1]);
            }
            if(!$this->fileName){
                $this->fileName = pathinfo($this->url,PATHINFO_BASENAME);
            }
            if(!$this->fileName)
                throw new Exception(__FUNCTION__ .": Filename not found");
        }
        return $this->fileName;
    }

    function getContentLength()
    {
        $info = $this->getInfo();
        return $info['Content-Length'];        
    }

    public function getContentType()
    {
        $info = $this->getInfo();
        return $info['Content-Type'];
    }

    public function getLocation()
    {
        $info = $this->getInfo();
        $info = array_change_key_case($info, CASE_LOWER);
        if($info['location']){
            return $info['location'];
        }
        return '';
    }

    public function saveLocal(string $filename)
    {
        $context = stream_context_create(array('ssl' => array(
            'verify_host' => false,
            'verify_peer' => false,
            'verify_peer_name' => false,
            'allow_self_signed' => true,
            'http' => array(
                'header'=>"Do-Not-Track: true\r\n"
            )
        )));
		$download = fopen($this->url,'rb', false, $context);
        if(!$download){
            throw new Exception('url_open:'.$this->url);
        }
		$file = fopen($filename,'a+');
		while ($buffer = fread($download,1048576)){
			fwrite($file, $buffer);
		}
		fclose($file);
		fclose($download);
    }


}

?>