<?php

class slToolsCrypt
{
	static public function createHash()
	{
		return str_replace('e','z',uniqid());
	}

     
	public static function encryptSymmetric(string $target)
    {
        $api = IceWarpAPI::instance();
        return $api->FunctionCall("ManageConfig",'crypt/encrypt','',$target);
    }


     
    public static function decryptSymmetric($encrypted)
    {
        $api = IceWarpAPI::instance();
        return $api->FunctionCall('ManageConfig','crypt/decrypt','',$encrypted);
    }

     
    public static function encryptSymmetricOld(string $target)
    {
        $reporting = error_reporting();
        error_reporting(E_ALL);
        $cipher = 'aes-128-cfb';
        if (!in_array($cipher, openssl_get_cipher_methods())) throw new Exception('Unknown openssl cipher: ' . $cipher);
        $initiationVectorLength = openssl_cipher_iv_length($cipher);
        $initiationVector = openssl_random_pseudo_bytes($initiationVectorLength);
        $encrypted = openssl_encrypt($target, $cipher, self::getSymmetricKey(), OPENSSL_RAW_DATA, $initiationVector);
        error_reporting($reporting);
        if(false === $encrypted) throw new Exception(openssl_error_string());
        return base64_encode($initiationVector . $encrypted);
    }

     
    public static function getSymmetricKey()
    {
        $api = IceWarpAPI::instance();
        $key = $api->getProperty('c_accounts_policies_superuserpassword');
        if(empty($key)) throw new Exception('API value c_accounts_policies_superuserpassword is empty');
        $key = hash("md5", $key, true);
        return $key;
    }

     
    public static function decryptSymmetricOld($encrypted)
    {
        $reporting = error_reporting();
        $cipher = 'aes-128-cfb';
        $encrypted = base64_decode($encrypted);
        $initiationVectorLength = openssl_cipher_iv_length($cipher);
        $initiationVector = substr($encrypted, 0, $initiationVectorLength);
        $data = substr($encrypted, $initiationVectorLength);
        if($data === false) return '';
        error_reporting(E_ALL);
        $result = openssl_decrypt($data, $cipher, self::getSymmetricKey(), OPENSSL_RAW_DATA, $initiationVector);
        error_reporting($reporting);
        if(false === $result) throw new Exception(openssl_error_string());
        return $result;
    }

     
    public static function decryptDbPassword($encrypted)
    {
        $api = IceWarpAPI::instance();
        return $api->FunctionCall('ManageConfig','dbpassword','0',$encrypted);
    }
}

?>