<?php

class slToolsCookie
{
     
    public $secure = false;
     
    public $httpOnly = false;
     
    public $options = null;

	public function __construct()
	{
		 		if(defined('SECURE_COOKIE') && SECURE_COOKIE){
			$this->secure = true;
			 		}

		 		if (isset($_SERVER['HTTPS'])) {
			$lowerString = strtolower($_SERVER['HTTPS']);
			if ($lowerString === 'on') {
				$this->secure = true;
			}
		}
		if (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] === '443') {
			$this->secure = true;
		}

		if(!$this->secure) return;
        if(function_exists('createobject')) $api = createobject('API');
        if(!is_callable([$api, 'GetProperty'])) return;
        $settingsFile = $api->GetProperty('C_ConfigPath').'_webmail/server.xml';
        if(!file_exists($settingsFile)) return;
        $xml = simplexml_load_file($settingsFile);
        if(filter_var($xml->item->allow_iframe, FILTER_VALIDATE_BOOLEAN)) $this->options = ['SameSite' => 'None'];
	}

	 	public function isSecure() {
		return $this->secure === true;
	}

	public function deleteAll(string $includePath = null)
    {
        if (!isset($_SERVER['HTTP_COOKIE'])) return;
        $cookies = explode(';', $_SERVER['HTTP_COOKIE']);
        foreach($cookies as $cookie) {
            $parts = explode('=', $cookie);
            $name = trim($parts[0]);
            setcookie($name, '', time()-1000);
            setcookie($name, '', time()-1000, '/');
            setcookie($name, '', time()-1000, './');
            if(!empty($includePath)){
                $includePath = trim($includePath, '/');
                setcookie($name, '', time()-1000, '/' . $includePath . '/');
                setcookie($name, '', time()-1000, '/' . $includePath);
            }
        }
    }

	public function setcookie($name, $value = "", $expire = 0, $path = "/",$domain = "")
	{
        $options = [
            'expires' => $expire,
            'path' => $path,
            'domain' => $domain,
            'secure' => $this->secure,
            'httponly' => $this->httpOnly,
        ];
        if(!empty($this->options)){
            $options = array_merge($options, $this->options);
        }
        return setcookie($name,$value ?? '',$options);
	}
}

?>