#!/usr/bin/perl -w

use Getopt::Long;
use IO::Socket;
use IO::Socket::UNIX;
use IO::Select;
use Socket;

my $opt_port = "/tmp/ctipd.stats";

sub usage()
{
	print STDERR
        "--port    - Stats port. default: $opt_port\n"
        ."--help    - Show this help message\n";
        exit 0;
}

my $result = GetOptions ("port=i"        => \$opt_port,
        			"help"          => \$opt_help);

if (defined $opt_help)
{
        usage();
}
	
my $client = new IO::Socket::UNIX(Type => SOCK_DGRAM, Blocking => 0, Proto => AF_UNIX) or
                die "failed to create client socket. $!";

my $client_sock = "/tmp/.stats_all"."_$$.sock";
unlink $client_sock;
my $client_addr = sockaddr_un($client_sock);
$client->bind($client_addr) or die "failed to bind client socket. $!";
chmod (0666, $client_sock);

my $server_addr = sockaddr_un($opt_port);
$client->send ("getall",0,$server_addr) or die "failed to send to server_socket $!";
my $sel = new IO::Select $client;
$sel->can_read(5) or die "timeout waiting for server"; 
$client->recv ($s, 100000);
print $s;

