<?php
/*
	This script lists all accounts from all domains - users, groups, lists etc. in CSV format
	Columns: Domain, Account, Alias, Type, Description
	Object types: 0=user, 1=mailing list, 2=executable, 3=notification, 4=static route, 5=catalog, 6=list server, 7=group, 8=resource
*/

// Invoke Global API COM object - "IceWarpServer.APIObject"
if ($base = icewarp_apiobjectcall(0, '', 'IceWarpServer.APIObject'))
{ 
	//echo "IceWarpServer.APIObject invoked\n"; 
}
else
{ 
	echo "API couldn't be invoked"; die(); 
}

echo "Domain, Account, Alias, Type, Description\r\n";

//Global API - "IceWarpServer.APIObject" usage
$domcount =icewarp_apiobjectcall( $base, 'GetDomainCount');
//echo "Domain count: $domcount\r\n";

$domlist = icewarp_apiobjectcall( $base, 'GetDomainList');
//echo "Domain list: $domlist\r\n";

for ($i=0; $i<$domcount; $i++) 
{
	$domainname = icewarp_apiobjectcall( $base, 'GetDomain', $i);
	//echo ($i+1).". domain: $domainname\r\n";

	$dbase = icewarp_apiobjectcall(0, '', 'IceWarpServer.DomainObject');
	icewarp_apiobjectcall( $dbase, 'Open', $domainname );

	$domname = icewarp_apiobjectcall($dbase, 'Name');
	//echo "Loaded domain: $domname\r\n";

	$accnum = icewarp_apiobjectcall($dbase, 'GetTotalAccounts', -1);
	//echo "Account count: $accnum\r\n";

	$acclist = icewarp_apiobjectcall($dbase, 'GetAccountList');
	//echo "Account list: $acclist\r\n";
	
	for ($j=0; $j<$accnum; $j++)
	{ 
		$acc = icewarp_apiobjectcall($dbase, 'GetAccount',$j); 
		//echo ($j+1).". account: $acc\r\n"; 

		// Account work - "IceWarpServer.AccountObject" usage 
		$abase = icewarp_apiobjectcall(0, '', 'IceWarpServer.AccountObject'); 
		icewarp_apiobjectcall( $abase, 'Open', "$acc@$domname" ); 
		//echo "Loaded account: $acc\r\n"; 

		// get account name and aliases using API variables 
		$accname = icewarp_apiobjectcall( $abase, 'GetProperty', 'U_Name' ); 
		$accalias = icewarp_apiobjectcall( $abase, 'GetProperty', 'U_Alias' ); 
		$acctype = icewarp_apiobjectcall( $abase, 'GetProperty', 'u_type' );
		$accdescription = icewarp_apiobjectcall( $abase, 'GetProperty', 'U_Comment' ); 
		$accdom = icewarp_apiobjectcall( $abase, 'Domain' ); 
		
		//echo "Domain, Account, Alias, Type, Description\n"; 
		echo "\"$domname\", \"$accname\", \"$accalias\", \"$acctype\", \"$accdescription\" \r\n"; 
	}
	
	// for user
	icewarp_apiobjectcall( $dbase, 'Close', $domainname );
}

//echo "\nAccount types:\r\n";
//echo "0=user, 1=mailing list, 2=executable, 3=notification, 4=static route, 5=catalog, 6=list server, 7=group, 8=resource";

// for domain
echo "\n";

ob_flush(); // send buffer to screen
//sleep(100); // pause script to see screen

?>
