Unit toolunit;
{$I LinuxMacros.inc}

Interface

Uses
  SysUtils,
{$IFNDEF TOOL_ACTIVEX}
  icewarpservercom,
{$ENDIF}
  SystemUnit,
  StringUnit,
  MimeUnit,
  StreamTools;

Const
  cComment = AnsiChar(';');
  cProto = AnsiString('://');
  cDisplaySep = AnsiString(': ');

  R_ERROR_API_INITIALIZATION = 1;
  R_ERROR_PARAMS = 2;
  R_ERROR_API_FAILURE = 3;
  R_ERROR_ACCOUNT_CREATE_USER_EXISTS = 4;
  R_ERROR_ACCOUNT_CREATE_PASSWORD_POLICY = 5;
  R_ERROR_ENV_VARS = 6;
  R_ERROR_USER_SWITCH = 7;
  R_ERROR_INVALID_PROPERTY = 8;
  R_ERROR_DOMAIN_PROBLEM = 9;
  R_ERROR_SERVICE_PROBLEM = 10;
  R_ERROR_BACKUP_PROBLEM = 11;
  R_ERROR_RESTORE_PROBLEM = 12;
  R_ERROR_STORAGE_PROBLEM = 13;
  R_ERROR_MERGE_PROBLEM = 14;
  R_ERROR_SETTINGS_PROBLEM = 15;
  _R_ERROR_TOP = R_ERROR_SETTINGS_PROBLEM;           // Set this to highest tool error

  R_CLEAN_BASE = 40;
  R_API_LASTERROR_BASE = 50;
  R_API_GENERIC_ERROR = 127;


Type
  TProcessItem = (piModify, piDisplay, piExport, piDelete, piImport, piSearch, piFile, piUpgrade, piCreate, piValidate, piLog, piClean, piMerge, piManageConfig);

{$IFDEF TOOL_ACTIVEX}
  TXAPIObject = OleVariant;
  TXDomainObject = OleVariant;
  TXRemoteAccountObject = OleVariant;
  TXAccountObject = OleVariant;
  TXTokenObject = OleVariant;
  TXServiceObject = OleVariant;

  TXObject = OleVariant;

{$ELSE}
  TXAPIObject = TAPIObject;
  TXDomainObject = TDomainObject;
  TXRemoteAccountObject = TRemoteAccountObject;
  TXAccountObject = TAccountObject;
  TXTokenObject = TTokenObject;
  TXServiceObject = TStatisticsObject;

  IDispatch = Pointer;

Const
  Unassigned = Nil;
{$ENDIF}

Function CreateObject(Obj: AnsiString): OleVariant;

Procedure Unset(Var Obj: TXObject);

Procedure APIInit(ACommand: TProcessItem; ASubParam: ansistring);

Procedure APIDone;

Procedure CreateRPC(ARPC: AnsiString);

Function GetCommaString(S: AnsiString; Index: Longint): AnsiString;

Function GetNextParam(Var Index: Longint; Out FParam: AnsiString; Var FValue: AnsiString; NoValue: Boolean = False): Boolean;

Function FindParam(Var Index: Longint; const Param: AnsiString; Var Value: AnsiString): Boolean;

Function GetProcessMode(Command: AnsiString): TProcessItem;

Function CommaString(Str: AnsiString): AnsiString;

Procedure ParseParameters;

Function ParamStr(Index: Longint): AnsiString;

Function ParseBatchLine(Line: AnsiString): Boolean;

Procedure Writeln(Str: AnsiString = ''; Force: Boolean = False);

Function IsStringMask(const S: AnsiString): Boolean;

function GetFileParamContent(const AFileName: ansistring): TAnsiStringList;

procedure GetDefaultSafeMask(var AVarMask: shortstring; const AMode: TProcessItem; const AIsEmail: boolean);

Var
  FAPI: TXAPIObject;
  FToken: TXTokenObject;
  TokenHandle: NativeUInt = 0;
  QuietMode: Boolean = False;
  ParamOptions: Longint = 0;
  InitPath: AnsiString = '';
  Filter: AnsiString = '';
  Template: AnsiString = '';

  OutputFileName: AnsiString = '';
  OutputFile: TstreamWriter;
  OutputToFile: Boolean = False;

Const
  // Commmands
  CCREATE = AnsiString('CREATE');
  CMODIFY = AnsiString('MODIFY');
  CSET = AnsiString('SET');
  CNEW = AnsiString('NEW');
  CADD = AnsiString('ADD');
  CDELETE = AnsiString('DELETE');
  CDROP = AnsiString('DROP');
  CDISPLAY = AnsiString('DISPLAY');
  CLIST = AnsiString('LIST');
  CGET = AnsiString('GET');
  CFILE = AnsiString('FILE');
  CEXPORT = AnsiString('EXPORT');
  CMANAGECONFIG = AnsiString('MANAGECONFIG');
  CIMPORT = AnsiString('IMPORT');
  CUPGRADE = AnsiString('UPGRADE');
  CSEARCH = AnsiString('SEARCH');
  CCHECK = AnsiString('CHECK');
  CVALIDATE = AnsiString('VALIDATE');
  CLOG = AnsiString('LOG');
  CMERGE = AnsiString('MERGE');

  // Parameters
  CACCOUNT = AnsiString('ACCOUNT');
  CREMOTEACCOUNT = AnsiString('REMOTEACCOUNT');
  CDOMAIN = AnsiString('DOMAIN');
  CTABLES = AnsiString('TABLES');
  CSYSTEM = AnsiString('SYSTEM');
  CUSERSTATISTICS = AnsiString('USERSTATISTICS');
  CCERTIFICATE = AnsiString('CERTIFICATE');
  CBATCH = AnsiString('BATCH');
  CSERVICE = AnsiString('SERVICE');
  CBACKUP = AnsiString('BACKUP');
  CGROUPWARE = AnsiString('GROUPWARE');
  CCLEAN = AnsiString('CLEAN');
  CSETTINGS = AnsiString('SETTINGS');

  // Options
  CQUIET = AnsiString('QUIET');
  CQ = AnsiChar('Q');

  CHELP = AnsiString('HELP');
  CH = AnsiChar('H');

  CRPC = AnsiString('RPC');
  CRCP = AnsiString('RCP');
  CREMOTE = AnsiString('REMOTE');
  CR = AnsiChar('R');

  CPATH = AnsiString('PATH');
  CP = AnsiChar('P');

  CFILTER = AnsiString('FILTER');
  CF = AnsiChar('F');

  COUTPUTFILE = AnsiString('OUTPUT-FILE');
  CO = AnsiString('O');

  CTEMPLATE = AnsiString('TEMPLATE');
  CM = AnsiChar('M');

  CTUTORIAL = AnsiString('TUTORIAL');
  CT = AnsiChar('T');

  CVERSION = AnsiString('VERSION');
  CV = AnsiChar('V');

  CouldNotInitAPI = AnsiString('Could not initialize the API');
  CouldNotInitRemoteAPI = AnsiString('Could not connect or authenticate to the remote server');
  ElevationRequired = AnsiString('Access Denied. Administrator permissions are needed to use the selected options. Use an administrator command prompt to complete these tasks.');
  EnvVarNotSet = AnsiString('ERROR: Environment variable %s is not set');
  ErrCannotFindUser = AnsiString('ERROR: Cannot find user %s');
  ErrCannotSwitchUser = AnsiString('ERROR: Cannot switch to user %s');
  ErrLocalOnly = AnsiString('ERROR: Command supported only on local server instance');
  ErrSettingsExists = AnsiString('ERROR: Settings already exist');

  DomainCannotBeDeleted = AnsiString('Domain cannot be deleted because API variable C_Domain_Cannot_be_deleted is true.');
  DomainCannotBeRenamed = AnsiString('Domain cannot be renamed because API variable C_Domain_Cannot_be_renamed is true.');

  SettingsUpdated = AnsiString('Settings updated.');
  SettingsProblem = AnsiString('Settings save problem.');
  SettingsCreated = AnsiString('Settings created.');

  BackupFinished = AnsiString('Backup to %s finished.');
  BackupProblem = AnsiString('Backup problem.');
  RestoreFinished = AnsiString('Restore from %s finished.');
  RestoreProblem = AnsiString('Restore problem');

  DomainDeleted = AnsiString('Domain %s deleted.');
  DomainNotFound = AnsiString('Domain %s not found.');
  DomainCreated = AnsiString('Domain %s created.');
  DomainUpdated = AnsiString('Domain %s updated.');
  DomainExists = AnsiString('Domain %s already exists.');
  DomainProblem = AnsiString('Domain %s save problem.');

  AccountDeleted = AnsiString('Account %s deleted.');
  AccountNotFound = AnsiString('Account %s not found.');
  AccountCreated = AnsiString('Account %s created.');
  AccountUpdated = AnsiString('Account %s updated.');
  AccountExists = AnsiString('Account %s already exists.');
  AccountProblem = AnsiString('Account %s save problem.');

  StorageOk = AnsiString('Storage conversion finished.');
  StorageFailed = AnsiString('Storage conversion problem.');

  ImportProblem = AnsiString('Import failed. Can not open file %s.');

  MergeOK = AnsiString('Merge successful.');
  MergeFailed = AnsiString('Merge failed.');

  PasswordPolicyViolation = AnsiString('Password policy violation.');

  cUALIAS = AnsiString('u_alias');
  cUALIASLIKE = AnsiString('( (u_alias like ''%0:s'') or (u_alias like ''%0:s;%%'') )');

Type
  TParameters = Array Of AnsiString;

Var
  Parameters: TParameters = Nil;

Implementation

Uses
  apishared,
{$IFDEF MSWINDOWS}
  Windows,
  ActiveX,
  ComObj,
{$ENDIF}
{$IFDEF UNICODE}
  AnsiStrings,
{$ENDIF UNICODE}
  TypesUnit,
  Variants,
  apiconst;

{$IFNDEF TOOL_ACTIVEX}
Function CoInitializeEx({%H-}Reserved: Pointer; {%H-}Val: Longint): Longint;
Begin
  Result := 0;
End;

Function CreateObject(Obj: AnsiString): OleVariant;
Begin
  Result := NativeUInt(CreateClassObject(Obj));
End;

Procedure Unset(Var Obj: TXObject);
Var
  plainObj: TObject;
Begin
  plainObj := TObject(Obj);
  FreeNil(plainObj);
  Obj := 0;
End;

{$ELSE}
Function CreateObject(Obj: AnsiString): OleVariant;
Begin
  CoInitializeEx(Nil, 0);

  Result := CreateOleObject(String(Obj));
End;

Procedure Unset(Var Obj: TXObject);
Begin
  Obj := Unassigned;
End;
{$ENDIF}

Procedure APIInit(ACommand: TProcessItem; ASubParam: ansistring);
Var
  FTokenError: Boolean;
  initStatus: longint;
  LicenseBypass: Boolean;
  licenseParam: ansistring;
Begin
  // Global API instance
  Try
    FAPI := Unassigned;
    FAPI := TXAPIObject(TXObject(CreateObject('IceWarpServer.APIObject')));
    FAPI.TokenHandle := TokenHandle;

    // Init path
    if Length(InitPath) > 0 Then
      FAPI.Init(UTF8ToWideString(InitPath));
  Except
  End;

  // Check API.Init error
  initStatus := FAPI.GetInitStatus;

  If initStatus <> S_OK then
  begin
    // Check for emergency license management bypass
    If Length(Parameters) > ParamOptions + 3 Then
    Begin
      LicenseBypass := (initStatus = E_LICENSE);
      LicenseBypass := LicenseBypass and (ACommand in [piModify, piDisplay]);
      LicenseBypass := LicenseBypass and (stricomp(PAnsiChar(ASubParam), CSYSTEM) = 0);
      licenseParam := LowerCase(Parameters[ParamOptions + 3]);
      LicenseBypass := LicenseBypass and ((licenseParam = 'c_onlinelicense') or (licenseParam = 'c_license') or (licenseParam = 'c_license_xml'));
    End
    Else
      LicenseBypass := False;

    if not LicenseBypass then
    begin
      Writeln(SafeFormat('API initialization error %d. Please, check the config directory and path settings', [initStatus]));

      APIDone;

      Halt(R_ERROR_API_INITIALIZATION);
    end;
  end;

  // Token error
  FTokenError := ((IDispatch(FToken) <> Nil) And (FToken.Counter = 0));

  // Check if instance created and if token set whether it has been acquired
  If (IDispatch(FAPI) = Nil) Or FTokenError Then
  Begin
    If FTokenError Then
      Writeln(CouldNotInitRemoteAPI)
    Else
      Writeln(CouldNotInitAPI);

    APIDone;

    Halt(R_ERROR_API_INITIALIZATION);
  End;
End;

Procedure APIDone;
Begin
  If IDispatch(FAPI) <> Nil Then FAPI.Done;
  Unset(TXObject(FAPI));
End;

Procedure CreateRPC(ARPC: AnsiString);
Var
  url: AnsiString;
Begin
  // Check ENV var
  if ARPC = '' then
    ARPC := StringToUTF8(GetEnvironmentVariable('IWS_TOOL_REMOTE'));

  // No ARPC given
  If ARPC = '' Then
  Begin
    // Get connection info
    Write('Enter the connection information (admin:pass@server): ');
    Readln(ARPC);
  End;

  // Get file contents
  If ARPC <> '' Then
  begin
    // Load to file
    If (Pos(cProto, ARPC) = 0) and FileExists(UTF8ToString(ARPC)) Then
      ARPC := LoadFileToString(ARPC);
  end;

  // No proto and no ","
  If (Pos(cProto, ARPC) = 0) and (Pos(cCom, ARPC) = 0) Then
    // Add https://
    ARPC := cHTTPSProto + ARPC;

  // No proto (use the obsolete format)
  If Pos(cProto, ARPC) = 0 Then
  Begin
    // url (user,pass,host,SSL)
    url := URLEncode(GetCommaString(ARPC, 0)) + cColon + URLEncode(GetCommaString(ARPC, 1)) + cAt + GetCommaString(ARPC, 2);

    // SSL support
    If GetCommaString(ARPC, 3) <> '' Then
      url := cHTTPSProto + url;
  End

  // url
  Else
    url := ARPC;

  Try
    // Create token object
    FToken := Unassigned;
    FToken := TXTokenObject(TXObject(CreateObject('IceWarpServer.TokenObject')));

    // Set url
    FToken.URL := UTF8ToWideString(url);

    // Get token handle
    TokenHandle := FToken.TokenHandle;
  Except
  End;
End;

Function GetCommaString(S: AnsiString; Index: Longint): AnsiString;
Var
  FC, FL, FI: NativeInt;
Begin
  Result := '';
  FL := 1;
  FC := 0;
  S := S + cComma;

  // For every char
  For FI := 1 To Length(S) Do
    // If comma
    If S[FI] = cComma Then
    Begin
      // Do we have our index
      If Index = FC Then
      Begin
        Result := Copy(S, FL, FI - FL);
        Break;
      End;

      // Inc counters
      Inc(FC);
      FL := FI + 1;
    End;
End;

Function FindParam(Var Index: Longint; const Param: AnsiString; Var Value: AnsiString): Boolean;
Var
  FIndex: Longint;
  FParam, FValue: AnsiString;
Begin
  Result := False;
  FIndex := Index;
  FValue := '';

  // For each param
  While GetNextParam(Index, FParam, FValue) Do
    // Match
    If LowerCase(FParam) = LowerCase(Param) Then
    Try
      // True
      Result := True;

      // Get value
      Value := FValue;
      
      Break;
    Except
    End;

  Index := FIndex;
End;

Function GetNextParam(Var Index: Longint; Out FParam: AnsiString; Var FValue: AnsiString; NoValue: Boolean = False): Boolean;
Var
  FL: NativeInt;
Begin
  Result := False;

  FParam := ParamStr(ParamOptions + Index);
  Inc(Index);

  If Not NoValue Then
  Begin
    FL := Pos(cEqual, FParam);
    If FL = 0 Then
    Begin
      FValue := ParamStr(ParamOptions + Index);
      Inc(Index);
    End
    Else
    Begin
      FValue := Copy(FParam, FL + 1, Length(FParam) - FL);
      FParam := Copy(FParam, 1, FL - 1);
    End;
  End;

  If Length(FParam) > 0 Then Result := True;
End;

Function GetProcessMode(Command: AnsiString): TProcessItem;
Begin
  Result := piDisplay;
  If (Command = CMODIFY) Or (Command = CSET) Then
    Result := piModify
  Else If (Command = CDISPLAY) Or (Command = CLIST) Or (Command = CGET) Then
    Result := piDisplay
  Else If (Command = CCHECK) Or (Command = CVALIDATE) Then
    Result := piValidate
  Else If (Command = CDELETE) or (Command = CDROP) Then
    Result := piDelete
  Else If (Command = CCREATE) Or (Command = CNEW) Or (Command = CADD) Then
    Result := piCreate
  Else If (Command = CSEARCH) Then
    Result := piSearch
  Else If (Command = CLOG) Then
    Result := piLog
  Else If (Command = CMERGE) Then
    Result := piMerge
  Else If (Command = CIMPORT) Then
    Result := piImport
  Else If (Command = CUPGRADE) Then
    Result := piUpgrade
  Else If (Command = CFILE) Then
    Result := piFile
  Else If (Command = CEXPORT) Then
    Result := piExport
  Else If (Command = CMANAGECONFIG) Then
    Result := piManageConfig
  Else If (Command = CCLEAN) Then
    Result := piClean;
End;

Function CommaString(Str: AnsiString): AnsiString;
Begin
  Result := Str;

  // Check quot
  If Pos(cSpeech, Result) <> 0 Then
    Result := StringReplaceEx(Result, cSpeech, cBackSlash + cSpeech, [rfReplaceAll]);

  // Escape commas
  If Pos(cComma, Result) <> 0 Then
    Result := cSpeech + Result + cSpeech;
End;

Function ParamStr(Index: Longint): AnsiString;
Begin
  Result := '';
  If Index < Length(Parameters) Then Result := Parameters[Index];
End;

function ParamStrInternal(const AIndex: longint): ansistring;
begin
  {$IFDEF LINUX}
  if AIndex = 0 then
  begin
    Result := system.ParamStr(0);
  end
  else
  begin
    if (AIndex < argc) then
      Result := strpas(argv[AIndex])
    else
      Result := '';
  end;
  {$ELSE}
  Result := StringToUTF8(System.ParamStr(AIndex));
  {$ENDIF}
end;

Procedure ParseParameters;
var
  FI: NativeInt;
begin
  SetLength(Parameters, System.ParamCount + 1);
  for FI := 0 to High(Parameters) do
    Parameters[FI] := ParamStrInternal(FI);
end;

Function ParseBatchLine(Line: AnsiString): Boolean;

var
  P: PAnsiChar;
  FS, S: AnsiString;
  FI, FL: NativeInt;
begin
  Result := False;

  If Length(Line) = 0 Then Exit;

  // We have an equal character
  FI := Pos(cEqual, Line);
  If FI <> 0 Then
  Begin
    FL := Pos(AnsiString('"'), Line);

    // Value with the equal sign
    If (FL = 0) Or (FI < FL) Then
    Begin
      // Blank value
      If Length(Line) = FI Then Exit;

      // Replace value
      Line[FI] := ' ';
      Insert('"', Line, FI + 1);
      Line := Line + '"';

      // Parameter
      FS := Copy(Line, 1, FI);
      FS := StringReplaceEx(FS, AnsiString('.'), AnsiString('_'), [rfReplaceAll]);
      Delete(Line, 1, FI);
      Line := FS + Line;
    End;
  End;

  // Command name
  SetLength(Parameters, 1);
  Parameters[0] := AnsiString(System.ParamStr(0));
  ParamOptions := 0;

  // Reset
  P := PAnsiChar(Line);
  FI := 0;

  // Loop
  While True Do
  Begin
    // Get next string
    P := GetParamPChar(P, S);
    If Length(S) = 0 Then Break;

    // Count
    Inc(FI);

    // Add new item
    SetLength(Parameters, FI + 1);
    Parameters[FI] := S;
    Result := True;
  End;
End;

Procedure Writeln(Str: AnsiString = ''; Force: Boolean = False);
Begin
  If Not QuietMode Or Force Then
    If not OutputToFile then
      System.Writeln(Str)
    else
      OutputFile.Writeln(Str);
End;

Function IsStringMask(const S: AnsiString): Boolean;
Begin
  Result := (Pos(cAsterisk, S) <> 0) Or (Pos(cAsk, S) <> 0);
End;

function GetFileParamContent(const AFileName: ansistring): TAnsiStringList;
var
  line: ansistring;
  data: ansistring;
begin
  Result := TAnsiStringList.Create;

  // Read from input
  If AFileName = '' Then
  begin
    while not eof do
    begin
      readln(line);
      Result.Add(line);
    end;
  end

  // Read from file
  else
  begin
    data := LoadFileToString(AFileName, {Delete}false, {UTF8}false, {RemoveBOM}true);
    CreateStringList(data, cLF, Result);
  end;
end;

procedure GetDefaultSafeMask(var AVarMask: shortstring; const AMode: TProcessItem; const AIsEmail: boolean);
begin
  // We do not have a safe mode
  if not (AMode in [piDisplay, piExport, piSearch, piValidate]) then
    exit;

  // Mask is blank
  if AVarMask = '' then
  begin
    // Default to all
    AVarMask := cAsterisk;
  end
  else

  // Email check
  if AIsEmail then
  begin
    // If no alias, default to all
    if ExtractAlias(AVarMask) = '' then
      AVarMask := cAsterisk + AVarMask;
  end
end;

End.
