program Example;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  SysUtils, GeneralAPIUnit, Classes;



Procedure GWExample(GroupEmail: AnsiString);
Var
  GWInstance,APIInstance : AnsiString;
  Sid,Gid,Data: AnsiString;
  Fields: THeaderIndexList;
  Fid: AnsiString;
  Lines: TStringList;
  S: String;
  Line, FdrId,FdrType,FdrDefault: AnsiString;
  DefaultContactFolderId, ItemId: AnsiString;
Begin
  GWInstance := CallAPI('0', '', 'IceWarpServer.Groupware');
  APIInstance := CallAPI('0', '', 'IceWarpServer.APIObject');
  SID :='';
  Lines:= TStringList.Create;

  Try
    GWLoginAs(GWInstance,APIInstance, GroupEmail,Sid,Gid);

    DefaultContactFolderId := '';


    Data:= CallAPI(GWInstance,'FunctionCall','GetFolderList', Gid,'','Fdr_Default');
    GetResultFieldsResultLines(Data, Fields);
    Lines.Text := String(Data);

    For S in Lines Do
    Begin
      Line := AnsiString(S);

      FdrId:= GetFieldResult(Line,'FDR_ID',Fields);
      FdrType:= GetFieldResult(Line,'FdrType',Fields);
      FdrDefault := GetFieldResult(Line,'Fdr_Default',Fields);

      If (FdrType = 'C') And (FdrDefault = '1') Then
      Begin
        //We havedefault contact folder
        DefaultContactFolderId := FdrId;
      End;

    End;


    If DefaultContactFolderId<>'' Then
    Begin
      // list items in the default folder
      Fid:= CallAPI(GWInstance,'FunctionCall','OpenFolder', Gid, DefaultContactFolderId);
      Try
        Data := CallAPI(GWInstance,'FunctionCall','GetItemList', Fid);
        GetResultFieldsResultLines(Data, Fields);
        Lines.Text := String(Data);

        For S in Lines Do
        Begin
          Line := AnsiString(S);

          ItemId:=  GetFieldResult(Line,'Itm_Id',Fields);

          //get the vcard of the contact
          Data := CallAPI(GWInstance,'FunctionCall','GetVCard', Fid,ItemId);

        End;

      Finally
        If Fid<>'' Then
          CallAPI(GWInstance,'FunctionCall','CloseFolder', Fid);

      End;

    End;





  Finally
    If GWInstance<>'' Then
    Begin
      If Sid<>'' Then
        CallAPI(GWInstance, 'FunctionCall', 'LogoutUser',Sid);

      CallAPI(GWInstance, '', '');
    End;

    If APIInstance<>'' Then
      CallAPI(APIInstance, '', '');

    FreeAndNil(Lines);
  End;

End;

begin
  If Not APIInit Then
  Begin
    Writeln('API initialization failure, probably api.dll is not visible');
    Exit;
  End;

  GWExample('a@t.com');

  APIDone;
end.
