#include "icewarp_api.h"
#include <stdlib.h>


#ifdef _WIN32
//#include <win32dep.h>
#include <windows.h>
#define APICALLTYPE    __cdecl
#endif 

#ifdef linux 
  #include <dlfcn.h>
  #if __WORDSIZE == 32
    #define APICALLTYPE    __attribute__((cdecl))
  #else
    #define APICALLTYPE
  #endif
#endif

typedef   char *  (APICALLTYPE *APICall)(const char *,const char *,const char *,const char *,const char *,const char *,const char *);
typedef   void  (APICALLTYPE *APIFree)(void *);

APICall gAPICall =NULL;
APICall gAPICallPersistent =NULL;
APIFree gAPIFree =NULL;

#ifdef _WIN32
static HMODULE gAPIDll;
#endif
#ifdef linux
static void *gAPIDll;
#endif

#ifdef linux
void *LoadLibrary(const char *LibraryName)
{
    if (LibraryName == NULL) {
        return NULL;
    }

    return dlopen(LibraryName, RTLD_LAZY);
}

bool FreeLibrary(void *LibraryHandle)
{
    if (LibraryHandle == NULL) {
        return false;
    }

    return dlclose(LibraryHandle);
}


void *GetProcAddress(void *LibraryHandle, const char *SymbolName)
{
    if ((LibraryHandle == NULL) || (SymbolName == NULL)) {
        return NULL;
    }

    return dlsym(LibraryHandle, SymbolName);
}
#endif


void init_API()
{
    // Initialize the IceWarp API so that logging functionality from API can be used
#ifdef _WIN32
    gAPIDll=LoadLibrary("api.dll");
#else
    gAPIDll=LoadLibrary("libapi.so");
#endif

    if (gAPIDll!=NULL) 
	{
        gAPICall=(APICall)GetProcAddress(gAPIDll,"icewarp_apiobjectcall");  
        gAPICallPersistent=(APICall)GetProcAddress(gAPIDll,"icewarp_apiobjectcall_persistent");  
        gAPIFree=(APIFree)GetProcAddress(gAPIDll,"icewarp_freeresult");  

        if ((gAPICall!=NULL)&&(gAPIFree!=NULL) &&(gAPICallPersistent!=NULL)) 
		{
			//OK
			// Add your own processing
        }
    }
}

void done_API()
{
 //unload the dll
  if (gAPIDll!=NULL) 
  {
	  FreeLibrary(gAPIDll);
  }
}
 


char *icewarp_apiobjectcall(const char *_Object,const char *_Method,const char *Parameter1,const char *Parameter2,const char *Parameter3,const char *Parameter4,const char *Parameter5)
{
	if (gAPICall!=NULL)
	{
		return gAPICall(_Object,_Method,Parameter1,Parameter2,Parameter3,Parameter4,Parameter5);
	}
	return 0;
}

char *icewarp_apiobjectcall_persistent(const char *_Object,const char *_Method,const char *Parameter1,const char *Parameter2,const char *Parameter3,const char *Parameter4,const char *Parameter5)
{
	if (gAPICallPersistent!=NULL)
	{
		return gAPICallPersistent(_Object,_Method,Parameter1,Parameter2,Parameter3,Parameter4,Parameter5);
	}
	return 0;
}
                           
 
void icewarp_freeresult(void *_Result)
{
	if(gAPIFree!=NULL)
	{
		gAPIFree(_Result);
	}
}