using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// IceWarp
using Icewarp.XmlRpcExample.XmlRpc.Base;
using Icewarp.XmlRpcExample.XmlRpc;
using Icewarp.XmlRpcExample.Utils;

namespace XmlRpcExample.XmlRpc
{
	public class IceWarpMultiCall : IceWarpXmlRpc
	{
		public IceWarpMultiCall(LoginCredentials credentials)
			: base(credentials)
		{
		}

		public void DoMultiCall()
		{
			IceWarpApi api = new IceWarpApi(m_credentials);
			string password = api.GetProperty("C_GW_SuperPass");
			string username = api.GetProperty("C_GW_SuperUser");

			string gwObject = SimpleMethodInvoker("0->Create", new string[] { "IceWarpServer.APIObject" });
			//string login = SimpleMethodInvoker(String.Format("{0}->FunctionCall", gwObject), new string[] { "loginuser", username, password, "", "" });			

			MultiXmlQuery query0 = new MultiXmlQuery("GetProperty", gwObject, new List<string>() { "C_GW_SuperPass" });
			MultiXmlQuery query1 = new MultiXmlQuery("GetProperty", gwObject, new List<string>() { "C_GW_SuperUser" });

			string result = MultiMethodInvoker(new List<MultiXmlQuery>() { query0, query1 });
		}
	}
}
