/*																	*
 * This file is a part of an example of how to communicate			*
 * with IceWarp Unified Messaging server using XML-RPC				*
 *																	*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.				*
 *																	*
 * IceWarp Ltd 2011													*
 *																	*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// Icewarp
using Icewarp.XmlRpcExample.XmlRpc.Base;
using Icewarp.XmlRpcExample.Utils;

namespace Icewarp.XmlRpcExample.XmlRpc
{
    public class IceWarpAccount : IceWarpXmlRpc
    {
        #region Ctor
        /// <summary>
        /// Ctor
        /// </summary>
        public IceWarpAccount(LoginCredentials credentials)
            : base(credentials)
        {
            CreateGroupwareComConnection();
        }
        #endregion // Ctor

        #region Public methods
        /// <summary>
        /// Creates COM object interface connection
        /// </summary>
        /// <returns>True if connection has been established, false otherwise</returns>
        public bool CreateGroupwareComConnection()
        {
            return CreateComConnection("IceWarpServer.AccountObject");
        }

        /// <summary>
        /// Returns value of the requested property
        /// </summary>
        /// <param name="propertyName">Property name</param>
        /// <returns>Property value</returns>
        public string GetProperty(string propertyName)
        {
            return MethodInvoker("GetProperty", new string[] { propertyName }) as string;
        }

        public string AuthenticateUser(string userName, string password)
        {
            return MethodInvoker("AuthenticateUser", new string[] { userName,password }) as string;
        }


        #endregion // Public methods
    }
}
