/*																	*
 * This file is a part of an example of how to communicate			*
 * with IceWarp Unified Messaging server using XML-RPC				*
 *																	*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.				*
 *																	*
 * IceWarp Ltd 2011													*
 *																	*/

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;

namespace Icewarp.XmlRpcExample
{
    public class SimpleXmlWriter
    {
        #region Nested types
        /// <summary>
        /// Class representing opened element.
        /// </summary>
        public class Element
        {
            #region Fields
            private string m_name;
            #endregion // Fields

            #region Properties
            /// <summary>
            /// Name of the element
            /// </summary>
            public string Name
            {
                get
                {
                    return m_name;
                }
            }
            #endregion // Properties

            #region Ctor
            /// <summary>
            /// Ctor
            /// </summary>
            /// <param name="name">Element name </param>
            public Element(string name)
            {
                m_name = name;
            }
            #endregion // Ctor
        }
        #endregion // Nested types

        #region Fields
		#region Presets
		private StringBuilder m_xmlContent = new StringBuilder();
		private List<string> m_openedElements = new List<string>();
		#endregion // Presets
		#endregion // Fields

		#region Ctor
		/// <summary>
        /// Ctor, empty prefix
        /// </summary>
        public SimpleXmlWriter()            
        {
			m_xmlContent.Append("<?xml version=\"1.0\"?>");
        }
        #endregion // Ctor

        #region Public methods
        /// <summary>
        /// Opens element and put it on the top of the element stack
        /// </summary>
        /// <param name="element">Element name</param>
        public void OpenElement(string element)
        {
            m_xmlContent.Append(String.Format("<{0}>", element));
            m_openedElements.Add(element);
        }

        /// <summary>
        /// Closes the most top element from the stack
        /// </summary>
        public void CloseElement()
        {
            string openedElement = m_openedElements.Last();
            m_xmlContent.Append(String.Format("</{0}>", openedElement));

            // remove last
            m_openedElements.RemoveAt(m_openedElements.Count - 1);
        }

        /// <summary>
        /// Closes all elements that has been previously opened
        /// by Open() call.
        /// </summary>
        public void Close()
        {
            while (m_openedElements.Count > 0)
            {
                CloseElement();
            }
        }

        /// <summary>
        /// Adds element with default prefix
        /// </summary>
        /// <param name="node"></param>
        /// <param name="nodeValue"></param>
        public void AddElement(string node, string nodeValue)
        {
            m_xmlContent.Append(String.Format("<{0}>{1}</{0}>", node, nodeValue));
        }

        /// <summary>
        /// Returns XML content
        /// </summary>
        /// <returns>XML content</returns>
        public string GetText()
        {
            return m_xmlContent.ToString();
        }

        /// <summary>
        /// Returns XML content
        /// </summary>
        /// <returns>XML content</returns>
        public override string ToString()
        {
            return GetText();
        }
        #endregion // Public methods
    }
}
