/*																	*
 * This solution is provided as an example of how to communicate	*
 * with IceWarp Unified Messaging server using XML-RPC				*
 *																	*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.				*
 *																	*
 * IceWarp Ltd 2011													*
 *																	*/

using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.Text;
using System.IO;

// Icewarp
using Icewarp.XmlRpcExample.XmlRpc;
using Icewarp.XmlRpcExample.Utils;
using XmlRpcExample.XmlRpc;

namespace XmlRpcExample
{
    class Program
	{
		#region Entry point
		static void Main(string[] args)
        {
			// Initialization
            string initialDirectory = String.Format(@"{0}\Logs", GetApplicationStartupPath());
            Logger.Instance.CreateLog(Logger.GetDirectoryName(initialDirectory), "all.txt");
			Logger.Instance.SetLogLevel(Logger.LogLevel.DebugPriority);

            // Creating communication object with administrator's credentials
            using (IceWarpGroupware gw = new IceWarpGroupware(new LoginCredentials("admin", "testdomain.com", "password", false, "localhost", 32000)))
            {
				// Substituting for user's account
				if (gw.LoginAsSuperuser("someotheruser@somedomainonserver.com"))
				{
					// Open group with main wildcard *
					string gid = gw.OpenGroup();
					// Create folder, no action is taken if folder already exists on the server
					IceWarpGroupware.CreateFolderResult createFolder = gw.CreateFolder(gid, "NewCalendar", IceWarpGroupware.FolderType.Calendar);
					// If folder was created or exists proceed other actions
					if (createFolder != IceWarpGroupware.CreateFolderResult.Failed)
					{
						// Open folder and get folder identification
						string fid = gw.OpenFolder(gid, "NewCalendar");

						// Reading event from EAS XML file
						string testEvent;
						if ((testEvent = ReadFile(@"Resources\event.xml")) != null)
						{
							string oid;
							if (!String.IsNullOrEmpty(oid = gw.AddVCalendar(fid, testEvent)))
							{
								Console.WriteLine("Test passed, following event was saved:");
								Console.WriteLine(gw.GetVCalendar(gid, oid, IceWarpGroupware.FormatType.Eas));
							}
							else
							{
								Console.WriteLine("Unable to load previously stored event from the server");
							}
						}
						else
						{
							Console.WriteLine("Reading test file failed");
						}
					}
					else
					{
						Console.WriteLine("Call to server failed");
					}
				}
				else
				{
					Console.WriteLine("Unable to substitute user");
				}
            }
		}
		#endregion // Entry point

		#region Private methods
		private static string ReadFile(string fileName)
		{
			string fileContent = null;

			if (File.Exists(fileName))
			{
				try
				{
					using (FileStream stream = File.Open(fileName, FileMode.Open))
					{
						if (stream != null)
						{
							using (StreamReader reader = new StreamReader(stream))
							{
								fileContent = reader.ReadToEnd();
							}
						}
					}
				}
				catch (IOException)
				{
					Console.WriteLine("Unable to read specified file");
				}
			}

			return fileContent;
		}

		private static string GetApplicationStartupPath()
		{
			string path = String.Empty;

			Assembly assembly;
			if ((assembly = Assembly.GetExecutingAssembly()) != null)
			{
				path = Path.GetDirectoryName(assembly.Location);
			}

			return path;
		}
		#endregion // Private methods
	}
}
