#!/usr/bin/perl

use strict;
use Getopt::Long;
use Time::Local;

$| = 1;

my $pidfile="/tmp/ctipd_log_server.pid";
my ($opt_verbose,$opt_help)=('','');
my ($ctid, $ip, $mintime, $maxtime, $force);
GetOptions ("ctid=s" 	=> \$ctid,	
	"ip=s" 		=> \$ip,
	"mintime=s"	=> \$mintime,
	"maxtime=s"	=> \$maxtime,
	"force"		=> \$force,
	"verbose"	=> \$opt_verbose,
	"help"		=> \$opt_help);	

if (!valid_params() || $opt_help) {
	usage();
	exit 0;
}

my $win_os=0;
$win_os=1 if ($^O eq "MSWin32");

close_file() if (defined($force));

my $dir;
if ($#ARGV < 0) {
	$dir=".";
} else { 
	$dir=join (" ",@ARGV);
}
my $cmd;
if ($win_os) {
  $cmd=generate_cmd_win();
} else {
 $cmd=generate_cmd();
} 
system ($cmd);
exit 0;

sub generate_cmd
{
	my $tcmd="";
	if (defined ($ctid)) {
		$tcmd="./ipdlogc.pl --hwhere '\$ctid =~ /$ctid/'";
	} else {
		$ip=~s/\./\\\./g;
		$tcmd="./ipdlogc.pl --hwhere '\$ip=~/$ip/'";
	}
	$tcmd.=" --mintime '".$mintime."'" if (defined($mintime));
	$tcmd.=" --maxtime '".$maxtime."'" if (defined($maxtime));
	$tcmd.=" $dir";
	return $tcmd;
}	

sub generate_cmd_win
{
	my $tcmd="";
	if (defined ($ctid)) {
		$tcmd=" perl ipdlogc.pl --hwhere " .'"'. "\$ctid =~ /$ctid/" . '"';
	} else {
		$ip=~s/\./\\\./g;
		$tcmd.="perl ipdlogc.pl --hwhere ".'"'."\$ip=~/$ip/".'"';
	}
	$tcmd.=" --mintime ".'"'.$mintime.'"' if (defined($mintime));
	$tcmd.=" --maxtime ".'"'.$maxtime.'"' if (defined($maxtime));
	$tcmd.=" $dir";
	return $tcmd;
}	

sub close_file
{
        if($win_os)
        {
				require Win32::Event;		
				my $event;
				$event = Win32::Event->open("log_server_event");
                	$event->set;
        }
        else
        {
				open(FH,$pidfile) or die "can't open pid file $pidfile";
                my $pid = <FH>;
                `kill  -s hup $pid`;
                close FH;
        }
}


sub valid_params
{
	if (!defined ($ctid) && ! defined ($ip) && !$opt_help) {
		print "Missing [ctid] or [ip] options.\n";
		return 0;
	}
	if (defined ($ip) && ! defined ($mintime) && !$opt_help) {
		print "Missing [mintime] option\n";
		return 0;
	}
	#return 0 if (defined ($mintime) && defined ($maxtime) && $mintime ge $maxtime);
	$maxtime = "\$now" if (defined($ip) && ! defined ($maxtime));
	return 1;
}



sub usage
{
	print "SYNOPSIS:\n\tperl get_tran.pl [Options] [Directory]\n\n"
	."DESCRIPTION:\n\tPrint transactions by given ctid value or IP address from logfiles in Directory (the current directory by default)\n\n"
	."OPTIONS:\n"
	."\t--ctid\t\tctid value (alternatively, use --ip)\n"
	."\t--ip\t\tSpecific IP address (alternatively, use --ctid)\n"
        ."\t--mintime\tReport start-time, mandatory parameter when --ip is used (YYYY-MM-DD HH:MM:SS)\n"
        ."\t--maxtime\tReport  end-time, default now (YYYY-MM-DD HH:MM:SS)\n"
        ."\t--force\t\tForce include in scanning the currently-open logfile\n"
        ."\t--help\t\tPrint usage\n"
        ."\t--verbose\tPrint debug info\n\n";

}
