#!/usr/bin/perl

use strict;
use Getopt::Long;
use Time::Local;

$| = 1;
my $pidfile="/tmp/ctipd_log_server.pid";
my ($opt_verbose,$opt_help)=('','');
my ($ip, $mintime, $maxtime, $force,$general, $byday, $sort);
GetOptions ("ip=s" 	=> \$ip,
	"mintime=s"	=> \$mintime,
	"maxtime=s"	=> \$maxtime,
	"force"		=> \$force,
	"general"	=> \$general,
	"day"		=> \$byday,
	"sort"		=> \$sort,
	"verbose"	=> \$opt_verbose,
	"help"		=> \$opt_help);	



if (!valid_params() || $opt_help) {
	usage();
	exit 0;
}

my $win_os=0;
$win_os=1 if ($^O eq "MSWin32");

close_file() if (defined($force));

my $dir;
if ($#ARGV < 0) {
	$dir=".";
} else { 
	$dir=join (" ",@ARGV);
}

my $cmd;
if ($win_os)
{
	$cmd=generate_cmd_win();
}
else
{
	$cmd=generate_cmd();
}
print "Command:\n".$cmd."\n" if ($opt_verbose);
system ($cmd);
exit 0;

sub generate_cmd
{
	my $tcmd="";
	if (defined ($ip)) {
		$ip=~ s/\,/\|/g if ($ip =~ /\,/);
		$ip=~s/\./\\\./g;
	}
	
	$tcmd="./ipdlogc.pl ";
	$tcmd.=" --hwhere '\$ip=~/$ip/'" if (defined ($ip));
	if (defined($general)) {
		$tcmd.=" --hcalc 'my \$ac=0; my \$acth=0; my \$tf=0; my \$tfth=0; my \$pf=0; if (\$dm>=300) {  \$pf=1;} elsif (\$dm >=202) { \$tfth=1;} elsif (\$dm==201) { \$tf=1;} elsif (\$dm>=101) { \$acth=1;} else {\$ac=1;}"; 
		if (defined $sort) {
			$tcmd.=" \$ip=~/(\\d+)\.(\\d+)\.(\\d+)\.(\\d+)/; my \$ipnum=\$1*(256**3) + \$2*(256**2) + \$3*256 + \$4;' --hselect '\$ipnum,\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime' --fhide --rhide --chide";
		} else {
			$tcmd.="' --hselect '\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime' --fhide --rhide --chide";
		}
		$tcmd.=" --mintime '".$mintime."'" if (defined($mintime));
		$tcmd.=" --maxtime '".$maxtime."'" if (defined($maxtime));
	
		$tcmd.=" $dir";
		if (defined $sort) {
			$tcmd.=" | ./csvaggregator.pl --groupby '\$1,\$2' --aggre 'sum(\$3),sum(\$4),sum(\$5),sum(\$6),sum(\$7),minstr(\$8),maxstr(\$8)' | ./csvsort.pl --by '\#\$1' | perl -n -e ' \$_=~/^\\d+,(.*)/; print \"\$1\\n\"; ' ";
		} else {
			$tcmd.=" | ./csvaggregator.pl --groupby '\$1' --aggre 'sum(\$2),sum(\$3),sum(\$4),sum(\$5),sum(\$6),minstr(\$7),maxstr(\$7)' | ./csvsort.pl --by '\$1'";
		}
		
	}
	if (defined($byday)) {
		$tcmd.=" --hcalc 'my \$ac=0; my \$acth=0; my \$tf=0; my \$tfth=0; my \$pf=0; if (\$dm>=300) {  \$pf=1;} elsif (\$dm >=202) { \$tfth=1;} elsif (\$dm==201) { \$tf=1;} elsif (\$dm>=101) { \$acth=1;} else {\$ac=1;} my \@arr=split / /,\$htime;"; 
		if (defined $sort) {
			$tcmd.=" \$ip=~/(\\d+)\.(\\d+)\.(\\d+)\.(\\d+)/; my \$ipnum=\$1*(256**3) + \$2*(256**2) + \$3*256 + \$4;' --hselect '\$arr[0],\$ipnum,\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime' --fhide --rhide --chide";
		} else {
			$tcmd.="' --hselect '\$arr[0],\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime' --fhide --rhide --chide";
		}
		$tcmd.=" --mintime '".$mintime."'" if (defined($mintime));
		$tcmd.=" --maxtime '".$maxtime."'" if (defined($maxtime));	
		$tcmd.=" $dir";
		
		if (defined $sort) {
			$tcmd.=" | ./csvaggregator.pl --groupby '\$1,\$2,\$3' --aggre 'sum(\$4),sum(\$5),sum(\$6),sum(\$7),sum(\$8),minstr(\$9),maxstr(\$9)' |  ./csvsort.pl --by '\$1,\#\$2' | perl -n -e ' \$_=~/^(\\d\\d\\d\\d\-\\d\\d-\\d\\d),\\d+,(.*)/; print \"\$1,\$2\\n\";'";  
		} else {
			$tcmd.=" | ./csvaggregator.pl --groupby '\$1,\$2' --aggre 'sum(\$3),sum(\$4),sum(\$5),sum(\$6),sum(\$7),minstr(\$8),maxstr(\$8)' |  ./csvsort.pl --by '\$1,\$2'";  
		}
		
	}
	return $tcmd;
}	

sub generate_cmd_win
{
	my $tcmd="";
	if (defined ($ip)) {
		$ip=~ s/\,/\|/g if ($ip =~ /\,/);
		$ip=~s/\./\\\./g;
	}
	
	$tcmd="perl ipdlogc.pl ";
	$tcmd.=" --hwhere ".'"'."\$ip=~/$ip/".'"' if (defined ($ip));
	if (defined($general)) {
		$tcmd.=" --hcalc ". '"'."my \$ac=0; my \$acth=0; my \$tf=0; my \$tfth=0; my \$pf=0; if (\$dm>=300) {  \$pf=1;} elsif (\$dm >=202) { \$tfth=1;} elsif (\$dm==201) { \$tf=1;} elsif (\$dm>=101) { \$acth=1;} else {\$ac=1;}"; 
		if (defined $sort) {
			$tcmd.=" \$ip=~/(\\d+)\.(\\d+)\.(\\d+)\.(\\d+)/; my \$ipnum=\$1*(256**3) + \$2*(256**2) + \$3*256 + \$4;".'"'." --hselect ".'"'."\$ipnum,\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime".'"'." --fhide --rhide --chide";
		} else {
			$tcmd.='"'." --hselect ".'"'."\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime".'"'." --fhide --rhide --chide";
		}
		$tcmd.=" --mintime ".'"'.$mintime.'"' if (defined($mintime));
		$tcmd.=" --maxtime ".'"'.$maxtime.'"' if (defined($maxtime));
	
		$tcmd.=" $dir";
		if (defined $sort) {
			$tcmd.=" | perl csvaggregator.pl --groupby ".'"'."\$1,\$2".'"'." --aggre ".'"'."sum(\$3),sum(\$4),sum(\$5),sum(\$6),sum(\$7),minstr(\$8),maxstr(\$8)".'"'." | perl csvsort.pl --by ".'"'."\#\$1".'"'." | perl -n -e ".'"'." \$_=~/^\\d+,(.*)/; print ".'\"\$1\n\"'."; ".'"';
		} else {
			$tcmd.=" | perl csvaggregator.pl --groupby ".'"'."\$1".'"'." --aggre ".'"'."sum(\$2),sum(\$3),sum(\$4),sum(\$5),sum(\$6),minstr(\$7),maxstr(\$7)".'"'." | perl csvsort.pl --by ".'"'."\$1".'"';
		}
	}
	if (defined($byday)) {
		$tcmd.=" --hcalc ".'"'."my \$ac=0; my \$acth=0; my \$tf=0; my \$tfth=0; my \$pf=0; if (\$dm>=300) {  \$pf=1;} elsif (\$dm >=202) { \$tfth=1;} elsif (\$dm==201) { \$tf=1;} elsif (\$dm>=101) { \$acth=1;} else {\$ac=1;} my \@arr=split / /,\$htime;"; 
		if (defined $sort) {
			$tcmd.=" \$ip=~/(\\d+)\.(\\d+)\.(\\d+)\.(\\d+)/; my \$ipnum=\$1*(256**3) + \$2*(256**2) + \$3*256 + \$4;".'"'." --hselect ".'"'."\$arr[0],\$ipnum,\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime".'"'." --fhide --rhide --chide";
		} else {
			$tcmd.='"'." --hselect ".'"'. "\$arr[0],\$ip,\$ac,\$acth,\$tf,\$tfth,\$pf,\$htime".'"'." --fhide --rhide --chide";
		}
		$tcmd.=" --mintime ".'"'.$mintime.'"' if (defined($mintime));
		$tcmd.=" --maxtime ".'"'.$maxtime.'"' if (defined($maxtime));	
		$tcmd.=" $dir";
		if (defined $sort) {
			$tcmd.=" | perl csvaggregator.pl --groupby ".'"'."\$1,\$2,\$3".'"'." --aggre ".'"'."sum(\$4),sum(\$5),sum(\$6),sum(\$7),sum(\$8),minstr(\$9),maxstr(\$9)".'"'." |  perl csvsort.pl --by ".'"'."\$1,\#\$2".'"'." | perl -n -e ".'"'." \$_=~/^(\\d\\d\\d\\d\-\\d\\d-\\d\\d),\\d+,(.*)/; print ".'\"$1,$2\n\"'.";".'"';
		} else {
			$tcmd.=" | perl csvaggregator.pl --groupby ".'"'."\$1,\$2".'"'." --aggre ".'"'."sum(\$3),sum(\$4),sum(\$5),sum(\$6),sum(\$7),minstr(\$8),maxstr(\$8)".'"'." |  perl csvsort.pl --by ".'"'."\$1,\$2".'"';
		}
		
	}
	return $tcmd;
}	

sub close_file
{
	if($win_os)
        {
                require Win32::Event;
                my $event;
                $event = Win32::Event->open("log_server_event");
                $event->set;
        }
        else
        {
  				open(FH,$pidfile) or die "can't open pid file $pidfile";
                my $pid = <FH>;
                `kill  -s hup $pid`;
                close FH;
        }
}


sub valid_params
{	
	if (! defined ($mintime) && !$opt_help) {
		print "Missing [mintime] option.\n";
		return 0;
	}
	#return 0 if (defined ($mintime) && defined ($maxtime) && $mintime ge $maxtime);
	$maxtime = "\$now" if (! defined ($maxtime));
	if (! defined($general) && ! defined ($byday) && !$opt_help ) {
		print "Missing [general] or [day] options.\n";
		return 0;
	}
	return 1;
}


sub usage
{
	print "SYNOPSIS:\n\tperl get_stats.pl [Options] [Directory]\n\n"
	."DESCRIPTION:\n\tPrint transaction statistics from logfiles in Directory (the current directory by default)\n\n"
	."OPTIONS:\n"
	."\t--ip\t\tSingle IP address or list of IP addresses separated by comma\n"
        ."\t--mintime\tReport start-time, mandatory parameter (YYYY-MM-DD HH:MM:SS)\n"
        ."\t--maxtime\tReport  end-time, default now (YYYY-MM-DD HH:MM:SS)\n"
        ."\t--force\t\tForce include in scanning the currently-open logfile\n"
        ."\t--general\tPrint stats for the entire report time (alternatively, use --day)\n"
        ."\t--day\t\tPrint stats by day within the report time (alternatively, use --general)\n"
	."\t--sort\t\tReport sorted by IP address\n"
        ."\t--help\t\tPrint usage\n"
        ."\t--verbose\tPrint debug info\n\n";

}

