#!/usr/bin/perl


use strict;	
use Getopt::Long;
my $prog = "$0";
my $version = "1.0.2";


my $opt_order_by;
my $opt_help = '';
my $opt_stdin = '';
my $opt_version = '';
my $opt_verbose = '';

my $code; 

my $fun_str;
my $main_str; 
my $opt_preview;
my $print_array_filed;

my @array;

my $result = GetOptions (
		"by=s"	=> \$opt_order_by,
		"preview"	=> \$opt_preview,
		"version"  	=> \$opt_version,
		"verbose"  	=> \$opt_verbose,
		"help"	   	=> \$opt_help,
		""		=> \$opt_stdin);



if ($opt_version)
{
	print "$version\n";
	exit;
}

if ($opt_help)
{
	print 'in general this tool does the equivalent to the orderby SQL statement and more:'."\n"
	.'options:'."\n"
	.'  --by "[-#field, ...]"   - list of fields to order by when .'."\n"
	.'    #filed                -  numeric order '."\n"
	.'    -filed                -  descending  order '."\n"
	.'  --help                     - print this usage information'."\n"
	.'  --version                     - print version number'."\n"
	."\n"
	.'examples:'."\n"
	.''.$prog.' --by "-#$1,$2"'."\n";

	exit;
}




$opt_stdin = 1 if (!$opt_stdin && $#ARGV < 0);

analyze_order_by ($opt_order_by);

my @fields;
my $rec_num =0;
my $line;

$code = <<EOC;
:0		:$fun_str;
:0		:while (<IN>) 
:0		:{	
:0			:\@fields = parse_record();
:0			:\$line = \$_;
:0			:$main_str
:0			:\$rec_num++;
:0		:}
:0			:return 1;
EOC

my $gen_code = prepare_code ($code);


sub prepare_code
{
	my $code = shift;
	$code =~ s/^:0\s*://mg;
	$code =~ s/^:.*\n//mg;
	return $code;
}



if ($opt_preview)
{
	print "\n";
	print "-----------------------------------------------------\n";
	print $gen_code ."\n";
	print "-----------------------------------------------------\n";

exit;
}


process_file ("&=STDIN") if ($opt_stdin);
process_files (\@ARGV, 1, 1);



# sort the array 
my @sorted = sort compare 
      @array; 

# print the array 
foreach my $sorted_line (@sorted)
{	
	print $$sorted_line[$print_array_filed] ."\n";
}








sub analyze_order_by
{
	my $in_by = shift; 
	my @by = split /,/, $in_by;
	
	my $singleby; 
	my $ordertype;
	$fun_str = "sub compare { ";
	my $counter = 0; 	
	foreach $singleby (@by)
	{
		if ($singleby =~ /^ *(\+|\-)?(\#)?\$([0-9]+) *$/)
		{
			$ordertype = "cmp"; #alphabetic	
			if ($2 eq "#")
			{
				$ordertype = "<=>"; #numeric
			}

			my $tempstr  = "\$a->[$counter] $ordertype \$b->[$counter]";		
			if ($1 eq "-") #  descending 
			{
				$tempstr  = "\$b->[$counter] $ordertype \$a->[$counter]";		
			}

			if ($counter == 0) 
			{
				$fun_str = $fun_str. $tempstr;
			}
			else 
			{
				$fun_str = $fun_str . " || ". $tempstr;  
			}
			
			$main_str= $main_str."\$array[\$rec_num][$counter] = lc(\$fields[$3 -1]);"."\n";
			$counter++;
		
		}
		else 
		{
		die "incorrect input  \n"; 
		}
	
	}
	$main_str = $main_str . "\$array[\$rec_num][$counter] = \$line;";
	$fun_str = $fun_str . " } ";
$print_array_filed = $counter;
	
}

sub process_files
{
	my $files = shift;
	my $force = shift;
	my $wc = shift;
	
	foreach my $arg (@$files)
	{
		if (-d $arg)
		{
			process_directory($arg);
		}
		elsif (-f $arg)
		{
			if ($force || $arg =~ /.*\.log/)
 			{
				process_file ($arg);
 			}
 			else
 			{
 				print "skipping file: $arg\n" if ($opt_verbose);
 			}
		}
		elsif ($wc)
		{
			process_wildcard ($arg);
		}
		else
		{
			die "file: $arg not found \n";
		}
	}
}


sub process_directory
{
	
	my $dir = shift;
	print "processing directory: $dir\n" if ($opt_verbose);
	
	my @files = glob ($dir."/*");
	foreach my $arg (@files)
	{
		if (-d $arg)
		{
			process_directory($arg);
		}
		elsif (-f $arg)
		{
			if ($arg =~ /.*\.log/)
			{
				 process_file ($arg);
			}
			else
			{
				print "skipping file: $arg\n" if ($opt_verbose);
			}
		}
		else
		{
			die "file: $arg not found \n";
		}
	}
	
}

sub process_wildcard
{
	my $wc = shift;
	my @files = glob ($wc);
	die "no files matching $wc \n" if ($#files < 0);
	process_files(\@files, 1, 0);
}

sub process_file

{
	my $file = shift;
	
	print "processing file: $file\n" if ($opt_verbose);
	
 	if ($file =~ /.*\.gz$/)
	{
		open (IN,"gzip -dc $file |") || die "could not open compressed file $file - $! \n";
	}
	else
	{
		open (IN,"<$file") || die "could not open $file - $! \n";
	}
	
		eval $gen_code 	 || die "failed to evaluate code: $@ \n";
	
	close (IN);

}




sub parse_record
{
	chomp;
	#return  split /,/,$_;
	my $record = $_;
		if ($record =~ /\\,/)
		{
			my $tmprecord = $record;
			$tmprecord =~ s/([^\\])((?:\\\\)*),/$1$2\000/g;
			$tmprecord =~ s/([^\\])((?:\\\\)*),/$1$2\000/g;
			return   split /\000/,$tmprecord;	
		}
		else 
		{
		   	return   split /,/,$record;	
		}
} 
  
