#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: user_del.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

deluser()
{
    good ""
    hilite "Delete account:"
    good ""

    getparam "Email address:"
    EMAIL=$PARAM

    good ""
    ask_with_confirmation "Delete this account?" "N" "y"
    if [ $? -eq 2 ]; then
        run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "delete" "account" "${EMAIL}"
        EXITCODE=$?
        if [ ${EXITCODE} -eq 0 ]; then
            good "Account deleted"
        else
            bad "Account deletion problem, error code ${EXITCODE}!"
        fi
    else
        warn "User cancelled"
    fi

    ask_with_confirmation "Delete another account?" "N" "y"
    if [ $? -eq 2 ]; then
        deluser
    fi
    return 0
}

deluser
exit 0
