#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: user_add.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

display_pwd_policy()
{
    PWD_USERALIAS=$(get_api_variable system c_accounts_policies_pass_useralias)
    PWD_MINLENGTH=$(get_api_variable system c_accounts_policies_pass_minlength)
    PWD_DIGITS=$(get_api_variable system c_accounts_policies_pass_digits)
    PWD_NONALPHANUM=$(get_api_variable system c_accounts_policies_pass_nonalphanum)
    PWD_ALPHA=$(get_api_variable system c_accounts_policies_pass_alpha)
    PWD_UPPERALPHA=$(get_api_variable system c_accounts_policies_pass_upperalpha)

    if [ $PWD_USERALIAS -eq 1 ]; then
        echo "        Password cannot contain username or alias"
    fi

    if [ $PWD_MINLENGTH -gt 0 ]; then
        echo "        Minimal password length is ${PWD_MINLENGTH} character(s)"
    fi

    if [ $PWD_DIGITS -gt 0 ]; then
        echo "        Password must contain at least ${PWD_DIGITS} digit(s)"
    fi

    if [ $PWD_NONALPHANUM -gt 0 ]; then
        echo "        Password must contain at least ${PWD_NONALPHANUM} non alphanumeric character(s)"
    fi

    if [ $PWD_ALPHA -gt 0 ]; then
        echo "        Password must contain at least ${PWD_ALPHA} alpha character(s)"
    fi

    if [ $PWD_UPPERALPHA -gt 0 ]; then
        echo "        Password must contain at least ${PWD_UPPERALPHA} uppercase charater(s)"
    fi
}

adduser()
{
    good ""
    hilite "Create new account:"
    good ""

    getparam "Email address:"
    EMAIL=$PARAM

    getpassword "Password:"
    PASSWORD=$PASSWORD_PARAM

    getparam "Full name:"
    FULLNAME=$EMAIL
    if [ "x$PARAM" != "x" ]; then
        FULLNAME=$PARAM
    fi

    ask_with_confirmation "Account is system administrator?" "Y" "n"
    if [ $? -eq 1 ]; then
        ADMIN="1"
    else
        ADMIN="0"
    fi

    good ""
    ask_with_confirmation "OK?" "Y" "n"

    if [ $? -eq 1 ]; then
        TRY_SAVE=true
        while $TRY_SAVE; do
            TRY_SAVE=false
            run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "create" "account" "${EMAIL}" "u_name" "${FULLNAME}" "u_password" "${PASSWORD}" "u_admin" "${ADMIN}"
            EXITCODE=$?
            case ${EXITCODE} in
                0)  good "Account created"
                    ;;
                4)  bad "Account already exists!"
                    ;;
                5)  bad "Password violates password policy!"
                    display_pwd_policy
                    echo ""
                    ask_with_confirmation "Retry?" "Y" "n"
                    if [ $? -eq 1 ]; then
                        getpassword "Password:"
                        PASSWORD=$PASSWORD_PARAM
                        TRY_SAVE=true
                    fi
                    ;;
                *)  bad "Account save problem, error code ${EXITCODE}!"
                    ;;
            esac
        done
    else
        warn "User cancelled"
    fi

    ask_with_confirmation "Add another user?" "Y" "n"
    if [ $? -eq 1 ]; then
        adduser
    fi
    return 0
}

adduser
exit 0
