#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: submitconf.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

submitconf()
{
    good ""
    ask_with_confirmation "${BAD}Overwrite current configuration with system.conf values?${NORMAL}" "N" "y"
    if [ $? -eq 2 ]; then
        run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "FILE" "BATCH" "config/system.conf" "modify system c." > /dev/null
        EXITCODE=$?
        if [ ${EXITCODE} -eq 0 ]; then
            good "Configuration submitted"
        else
            bad "Configuation submit problem, error code ${EXITCODE}!"
        fi
    else
        warn "User cancelled"
    fi
    return 0
}

submitconf
exit 0
