#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: ssl_gen_cert.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

gensslcert()
{
    pushd "$IWS_INSTALL_DIR" > /dev/null
    run_cmd_log "openssl req -x509 -nodes -newkey rsa:1024 -keyout config/cert.pem -out config/cert.pem"
    popd > /dev/null
}

good ""
ask_with_confirmation "Create a new SSL/TLS Certificate?" "Y" "n"
if [ $? -eq 1 ]; then
    gensslcert
else
    warn "User cancelled"
fi

exit 0
