#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: domain_add.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

adddomain()
{
	GW_AVAIL=$(get_api_variable "system" "C_GW_IsAvailable")
	if [ "${GW_AVAIL}" == "0" ]; then
		bad "GroupWare service is not available, please start it"
		echo "        If you really want to create a domain without running GW, use tool.sh directly"
		echo ""
		return 0
	fi
	
    good ""
    hilite "Create new domain:"
    good ""

    getparam "Domain name:"
    DOMAINNAME=$PARAM

    getparam "Domain description:"
    DOMAINDESC=$DOMAINNAME
    if [ "x${PARAM}" != "x" ]; then
        DOMAINDESC=$PARAM
    fi

    getparam "Administrator email address:"
    DOMAINADMIN="postmaster@${DOMAINNAME}"
    if [ "x${PARAM}" != "x" ]; then
        DOMAINADMIN=$PARAM
    fi

    good ""
    ask_with_confirmation "OK?" "Y" "n"
    if [ $? -eq 1 ]; then
        run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "create" "domain" "${DOMAINNAME}" "d_description" "${DOMAINDESC}" "d_adminemail" "${DOMAINADMIN}"
        EXITCODE=$?
        if [ ${EXITCODE} -eq 0 ]; then
            good "Domain created"
        else
            bad "Domain save problem, error code ${EXITCODE}!"
        fi
    else
        warn "Domain cancelled"
    fi

    ask_with_confirmation "Add another domain?" "Y" "n"
    if [ $? -eq 1 ]; then
        adddomain
    fi
    return 0
}

adddomain
exit 0
