#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: db_filesystem.sh - wizard menu script
#

# Storage type
# 0 - Professional file system
# 1 - Standard file system
# 2 - ODBC

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

fnc_db_filesystem_accounts()
{
    good ""
    ask_with_confirmation "Switch accounts storage to file system?" "Y" "n"
    if [ $? -eq 1 ]; then
        good "Switching accounts storage to file system..."
        run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "modify" "system" "C_System_Storage_Accounts_StorageMode" "1"
        EXITCODE=$?
        if [ ${EXITCODE} -ne 0 ]; then
            bad "Error calling tool, error code ${EXITCODE}"
            return 1
        fi
        good "Storage switched."
    else
        warn "Storage was not switched."
        return 0
    fi

    good ""
    ask_with_confirmation "Convert data from database to file system?" "Y" "n"
    if [ $? -ne 1 ]; then
        return 0
    fi

    good "Converting data from database to filesystem..."
    run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "set" "storage" "0"
    EXITCODE=$?
    if [ ${EXITCODE} -ne 0 ]; then
        bad "Error calling tool, error code ${EXITCODE}"
        return 1
    fi
    good "Data converted."
    return 0
}

SCRIPT_NAME=`basename $0`
RES=0
case $SCRIPT_NAME in
    "db_filesystem_accounts")
        fnc_db_filesystem_accounts
        RES=$?
        ;;
    *)
        echo "Script called for unknown operation: ${SCRIPT_NAME}"
        RES=1
        ;;
esac

exit $RES
