#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: voicemail.sh - server internal script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

export IWS_INSTALL_DIR

# include functions
source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"
if [ $? -ne 0 ]; then
    echo "Can not find functions include file"
    exit 255
fi

LOGLEVEL=$(get_api_variable system C_System_Log_Services_SIP)
if [ "${LOGLEVEL}" == "4" ]; then
    # obtain log directory
    LOGDIR=$(get_api_variable system c_system_storage_dir_logpath)
    mkdir -p "${LOGDIR}/voip"
    LOGFILE="${LOGDIR}/voip/voicemailstartup.log"
else
    LOGFILE="/dev/null"
fi

cd "${IWS_INSTALL_DIR}/voip" &> /dev/null
java "$@" &> "${LOGFILE}" & echo $! > "${IWS_INSTALL_DIR}/var/voicemail.pid"

exit 0
