#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: slapd.sh - server internal script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

export IWS_INSTALL_DIR
export LD_LIBRARY_PATH="${IWS_INSTALL_DIR}/ldap/lib:${LD_LIBRARY_PATH}"

# include functions
source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"
if [ $? -ne 0 ]; then
    echo "Can not find functions include file"
    exit 255
fi

# obtain log directory
LOGDIR=$(get_api_variable system c_system_storage_dir_logpath)
mkdir -p "${LOGDIR}/ldap"

# start slapd
cd "${IWS_INSTALL_DIR}/ldap" &> /dev/null
"${IWS_INSTALL_DIR}/ldap/libexec/slapd" "$@" &> "${LOGDIR}/ldap/slapd.log" &

exit 0
