#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: liccheck.sh - liccheck script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

export IWS_INSTALL_DIR
export IWS_PROCESS_USER
export LD_LIBRARY_PATH="${DIR}/lib64:${DIR}/lib:${LD_LIBRARY_PATH}"

exec "${DIR}/liccheck" "$@"
