#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2022 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: php.sh - server internal script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

# test for argument
if [ "x$1" == "x" ]; then
    exit 255
fi

export IWS_INSTALL_DIR
export KL_PLUGINS_PATH="${IWS_INSTALL_DIR}/kaspersky/ppl"
export KL_UPD_PLUGINS_PATH="${IWS_INSTALL_DIR}/kaspersky/updater"
export LD_LIBRARY_PATH="${IWS_INSTALL_DIR}/php/lib:${IWS_INSTALL_DIR}/${IWS_LIB_DIR}:${IWS_INSTALL_DIR}/lib:${IWS_INSTALL_DIR}/kaspersky:${IWS_INSTALL_DIR}/kaspersky/${IWS_LIB_DIR}:${IWS_INSTALL_DIR}/kaspersky/lib:${IWS_INSTALL_DIR}/kaspersky/updater:${IWS_INSTALL_DIR}/kaspersky/ppl:${IWS_INSTALL_DIR}/avast:${IWS_INSTALL_DIR}/purple/lib:${IWS_INSTALL_DIR}/eset/lib:${LD_LIBRARY_PATH}"
export ENCHANT_CONFIG_DIR="${IWS_INSTALL_DIR}/enchant"

exec "${IWS_INSTALL_DIR}/php/php" -c "${IWS_INSTALL_DIR}/php/php.ini" "$@"
