#!/bin/bash

usage()
{
	echo "$0 filename [dirname]"
	exit 1
}

if [ $# -lt 1 ] || [ $# -gt 2 ]; then
	usage
fi

FILENAME="$1"
if [ $# -eq 2 ]; then
	DIRNAME="$2"
else
	DIRNAME="${FILENAME}_libs"
fi

mkdir -p "$DIRNAME"

ldd "$FILENAME" | while read LINE; do
	LIBNAME=$(sed 's/.*=> //' <<< $LINE | sed 's/ (.*//')
	cp -f "$LIBNAME" "$DIRNAME"
done 

tar zcfv "${DIRNAME}.tar.gz" "$DIRNAME"

