/*
 * (c) Copyright Ascensio System SIA 2010-2019
 *
 * This program is a free software product. You can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License (AGPL)
 * version 3 as published by the Free Software Foundation. In accordance with
 * Section 7(a) of the GNU AGPL its Section 15 shall be amended to the effect
 * that Ascensio System SIA expressly excludes the warranty of non-infringement
 * of any third-party rights.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  PURPOSE. For
 * details, see the GNU AGPL at: http://www.gnu.org/licenses/agpl-3.0.html
 *
 * You can contact Ascensio System SIA at 20A-12 Ernesta Birznieka-Upisha
 * street, Riga, Latvia, EU, LV-1050.
 *
 * The  interactive user interfaces in modified source and object code versions
 * of the Program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU AGPL version 3.
 *
 * Pursuant to Section 7(b) of the License you must retain the original Product
 * logo when distributing the program. Pursuant to Section 7(e) we decline to
 * grant you any rights under trademark law for use of our trademarks.
 *
 * All the Product's GUI elements, including illustrations and icon sets, as
 * well as technical writing content are licensed under the terms of the
 * Creative Commons Attribution-ShareAlike 4.0 International. See the License
 * terms at http://creativecommons.org/licenses/by-sa/4.0/legalcode
 *
 */

"use strict";

(function(window, undefined){

var _presentation_editor_themes = [];

_presentation_editor_themes[0] = {
    Name: "blank",
    Url: "/theme1/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAAmCAYAAAC1Q9c1AAAEbUlEQVRoQ+2ZWyhtaxTH/8st4UEo5J7InU4oFA8c5JI6Euko16SkJITyQEQcJw+Ua8r1QSfJtSM5SQgnD665JXdyHlzy4LL3Ht9u6ayzlr2W1Zq7PY9vvDHnHHN+vzG+Mf7jW5JPXwzcNEpAwqFqlCdzxqFqnimHKgBTDpVDFYKAAD55TeVQBSAggEu1M/Xy8hKnp6fsk7y8vKClpSXA54nTpdpQY2JiMDo6ylY9MjKC6OhocRIQ4KvVgnp2dgYbGxvo6enh4eGBASWw3L4SUAtqTU0NSkpKkJ+fj9bWVgZ2f38fdnZ2nKu6UJ2dnbGzs4OpqSm0t7djYGAApaWlqKqq4lDVgTo7O4vg4GCYmpri/PwcExMTiI2Nhbm5OY6OjqCrq/sm2OvrawwODmJhYQFXV1fQ0dGBtbU1IiIiQDVaIpH8L4Ly7u2flpaGrq4u5OTkoLm5GU9PT7CysgKpAcrYxMREhWD6+vqQnZ2Nu7s7hdfDwsIwNjb2zaCIhfi7oBIQCwsL3N/fY3FxEf7+/mydBQUFaGhoQEhICGZmZuTWvr6+Dh8fHxYAKhMZGRkssynTu7u7UVlZiZeXF3R2doKCJnZ7F9SOjg5kZmbCzc0NBEpqa2tr8PT0ZH9ubGzA1dVVhktubi6ampqQlJSE/v5+OWbJycns/1lZWazxid3eBTUwMBDz8/Oora1FUVGRzNr9/PywvLyMvLw8NDY2ylw7PDzE5uYmnJyc4OjoKMesuroaZWVlILi9vb1iZ6q6pNra2mIZSJMTZaalpaXM4inDiouLYWxsjJOTExgYGCiE8/z8DIK8t7eH7e1trKysYHx8HBcXF6weU10Wu6mcqZSZdXV1Kq2XykR6errMvQSPMpIAkq6VGnV8MzMzpgY+FFRqMDRBUWNxcXGBoaGhQrh0FkDTlq+vL5aWll7vGRoaQkJCAmtU5CcoKAgeHh7szCAgIIDVUdr+Hwrq8PAw4uLi2JambWpkZKQQ6uTkJCIjI9k1gkpw6XdFmrRIw6ampqKtrY3p039bYWEh6uvrPxZUAkpglTUSkkX29vYMIG1/KgMUBJJhZFSL3d3d5QIibXLx8fFsOBC7Ka2pBIWmHtq6VA+lmfjWwsvLy5nupKymckBZSc2LnlekQ+leeoYsKirq9eRLzGCVQqXmRE2Ksu34+Bja2trfXO/BwQGTTbTtSVqRxEpJSUFPTw/09fWZzqVspZGVai3JMKqxc3Nz8Pb2xurqqph5sm9XCpWEPmlMOpGiqUkVCw0NxfT0NJNgNAzQBEZyq6WlhWWs1GhgqKioQHh4OExMTPD4+AgKiq2trSqv+WHvUQpVk19+c3OD3d1d3N7ewsHBQfTw3mLzXaFqMkA/si8OVYDocKgcqgAEBHApl6m/tm8ofE1Pphv+Kf9J4TWTir9Bh9CKjAYG/PXGiX7IJ/xcMKfwuT9/C0L+H1+ns//a779MCIBCcy45VM2xfPXEoX4PqAK848O55N1fgJBzqByqAAQEcPkZ5j9orWxUdUMAAAAASUVORK5CYII="
};

_presentation_editor_themes[1] = {
    Name: "pixel",
    Url: "/theme2/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[2] = {
    Name: "classic",
    Url: "/theme3/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[3] = {
    Name: "official",
    Url: "/theme4/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[4] = {
    Name: "green",
    Url: "/theme5/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[5] = {
    Name: "lines",
    Url: "/theme6/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[6] = {
    Name: "office",
    Url: "/theme7/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAAmCAYAAAC1Q9c1AAAJXUlEQVRoQ+2aC3AV1RnHv929IQ+vgYQ8UEISQISJYQQViI5ig4+AOjxsBAbrWFuxg+i0lTjjVKmjFZjWoq2jMAoyzqAoDo7aUipJCI8KKIIojYmEMCQkEgmQBJKQm+Tubv/fd/aGG3KB5JakuZ17Jq89Z/ecPb/z/x7n3GgzXthiU7hcVgJaGOpl5SmdhaFefqZhqL3ANAw1DLU3CPRCn2GfGobaCwR6ocugldraVE+exlPySrHJI0jT9V54vdDsMmioX7z3LB0v+0JmPenBJTTk2qzQJNALbx0UVFZo/itzSTciyGxvpWQAzQLYcFEEgoJa9q/3qbRwNY28OZcq9m0E2Da66zfvUsyg5DDXYKEWvvYwNZ+qplsefpkq922iH4q30qjb5lHGnb8MQw0G6qnKA/T5mt/SgJhYysnbQLXle+jLdc9RpDuO7n7qA7gE1wXBtp09TcdKdlBdVSnx35puUHRsAiVdM0FciKZp/xeL0mPz//rjP1HVN5spfcJ0uv6+X5NlmpS/fDa1NjfQTQ88R0MzswOCqT6whb79+6vkbWsJ2J444gbK+tmyiy5KqBDvEVRvawt99udcMts8NHn+GxSXMkbmWfzZSjq8ewMNTr+ebn3klS5zP1NbQdtWPka2ZYqbSLthmiib07Kqbwvo4PZ3CY00fubTlDp+aqiwC/ieMDa7R1Arv95E33y6nK5MTKMpT6zp6PTM8SO0dcWjcs313O5fDvzjNTqy51NRMav5/LJ3wxL64d9FlHbjvTRu+lOhCtVm92Xbds+i/47VT1J9VQll3DWfRt06t9Pkt7/5ODUcO0gjJs2isfc80antbMNxajxRSe7BKXRF/NVdoJXteI9Kt6yhlLF30I25vws5qMySX5p5onRfqY0njlLR648gCdNpysLVFOUe3GnynFqVFKyiiCg33b1oPbkGRAWEwy6AITfX11DTySosRJkEO3YFQzN/AiUvDhmoCqajTsRYVqpl9UCp3+W/ReU713drwuNm5Inf9C8Mr2zHOgHIG4aOghcZEDOQ2hDoQgWqP0yeh8pabFGqoXdTqRLhsYNqbaojd0LqBVXIOy3+HnT1aLr9Vys6uNWUfk5fffiiBKrogUkUP+w6nBcMlzODuJQM5Lobxfz7O9TzYersQTVQxE82e7422QV05zOqmu930Z73F5MREUVTn95ArsjogIqtLf+Kdq99RtomP7aC4oaOFsdd8Oo8ajldS8PG5SAQLULaZHR6/rvNb1L5rg/7LdRLwTSA1QRXnqthaN0LVF+uW0w/Htx1yUBiWxYV/OVBAZg6fhpSpDzywFdufjlXIGYvfJtik9K7LIgvyF2VMZkmznm+Wy6mD24CJjFuEQaXQMq0IExWqpg97vRyxaWUylDyl88R0+XkPHnUxIvOp7ToHSrbvlZUnZO3XnZNm5bNkOcD5aEHce/3eIZL8qhJGGNpH/C68BA+Vfp8pOSdoOZv5gabuQNTB0yf2TN9l8vQtFl/KJCowU/hu8se8xCCUwmCVKQ7nnIWfSCQLlY4qhf+9SHJL8ZOW0gjsu6nfR8to+oDhaS7BiCA3UNXQq3tLWeopnSnpGHxqZlUd7SYYoeMpOwFb/0voEqO6YCU8flaweRf6pqPjGGMolzARN25a5cBtAj98Km6NmdpfhNuJ9NioLaNjMDgBobMfW95/RfUhByTT6Qypy7o1oR3vpNHJ4/sJzc2AXdgM8BbU063KvZuFMX6CgerMdk/p8SRN9E//zhTtrx9ddrlyy39zZsh+RJ4BZJNHmEdlVaHC8C1jmuA4gIXirBP5OXID/wGK/WZVbsbq2tb5FkT1WDPqkUnJr41HQh4pQynz//qxKPd00zNdccA+SyOCYf09VGh+DyYGpwgEHG4dsApkEqB/Bc+xYCiIDDQZHisSgbEt5uch7JqGZiOa1Yg2sGSTK8oVZysWdvgMUsq66y95Set4sMN8pAJr2FbmmZiDEsyWlYwJ7cWYEPJso6o7b9FpCRmzfbnQOyoc95bQDqmDk1J9s4weWps7ixRx386cNUTgCvBiZXKwgNczaWTpaNS3IYfF/7bKq6oN/cfrqNDx07b1T82WV62AFYvHIpl6zqG5bEge4swoMFuhhtECsptyLv3AW8HnG8k35B+U5I3gpQAi4MNA5a7UCeyQDVDZPXKSztQOqtUKZxVylNlkHgawhPlakijbBfq2uEDVMbaGer5HKxmj9csqaiz9x+utw/VNFLdmbOEVRFXbXlN6FY34CfZf+vwyywLGRjXsomTfZzUiPUIcJ/ZdVrOC6xA5yNWjhrKHjko8ERFhc4KCjRRJ8NSJi7JI9cxWEeW/AREBZgwc9Ek2zy6VtQEOEPjvn1wwdoxeU3zgiYX9qG6ZgAuRIbxIjhYdQNqH4gtuCHuf2krWwqv3XncxUFKMGEVqqMjvo/vVB/5ngtGypNyvc+X8loptJaloyDXkT5UverWkETJFrg8OAPn59vhAri9i1JnvlgUcJaf/H4KbZ81PWDb7R//jVYXzgvY9uid6+iF+WsDtj2/6iG676PdAds2/vRm8qzMCdgWtWAz5b5UBM8jx7AiNfXFZoAvzAzTVrmlCJbtxLEPcaASfUXprHhm6EicTQn2DIiwRl4xbmRonJvCEM/B5ToV+QQuB7bscVfZs28b3tX8QwXqA0u2Ij44vlPcjKgF+AQsuwjZlLO0GKyqZLqCEneqgMKBBd4LwPC4L2/iIAWwkgGArJMBSeCSFApwOeqztxgSF21PGpNo3zshhZIGRUkaGrJKnb1kG5SqnLYfUIhUqUvQqsxIRf4OYEqX4MFxVUV5ABQQaJLIL85VklZmLqaNeCQqZWVfER1BWWOS7AmjE7SJ1yZ0yYIuFaiCc3h98NTcpdu8Kung1AdpH0cagSTyVcERG0hgVcFMTpPEt0oAFaisWPHKqGVlS7IP/qx4cJWQK17E0K9LHWhlpsdRWrLbB5KbA/5bTn+DqlIHzBNZh3XkeKPd3Gpq1bXym47WNnFWQSfrPXSqsY1TO4uPMbgAhMBhXTq7S2zKlaUzb433NELMyYuUv5RDE/HLDBs1acmxWkykYY8dHq8lxEZSYmykDZg9ShP7G9SLabwDuL8asXGxTpxuEdExliaP16440SybR1/w6XABKhmQWzOGDQRjUa0dEx2hpSe7fWP71B70P4eFEtQ+cCqXZ4j/AEwqelbEjWUvAAAAAElFTkSuQmCC"
};

_presentation_editor_themes[7] = {
    Name: "safari",
    Url: "/theme8/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[8] = {
    Name: "dotted",
    Url: "/theme9/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[9] = {
    Name: "corner",
    Url: "/theme10/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[10] = {
    Name: "turtle",
    Url: "/theme11/",
    Thumbnail: "data:image/png;base64,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"
};

    //--------------------------------------------------------export----------------------------------------------------
    window['AscCommon'] = window['AscCommon'] || {};
    window['AscCommon']._presentation_editor_themes = _presentation_editor_themes;
})(window);
