<?php

 
if (!function_exists('curl_init')) {
         define ('CURLOPT_HEADERFUNCTION', 20079);
    define ('CURLOPT_RETURNTRANSFER', 19913);
    define ('CURLOPT_SSL_VERIFYPEER', 64);
    define ('CURLOPT_SSL_VERIFYHOST', 81);
    define ('CURLOPT_USERAGENT', 10018);
    define ('CURLOPT_HEADER', 42);
    define ('CURLOPT_CUSTOMREQUEST', 10036);
    define ('CURLOPT_POST', 47);
    define ('CURLOPT_POSTFIELDS', 10015);
    define ('CURLOPT_HTTPHEADER', 10023);
    define ('CURLOPT_URL', 10002);
    define ('CURLOPT_HTTPGET', 80);      define ('CURLOPT_CONNECTTIMEOUT', 78);
    define ('CURLOPT_TIMEOUT', 13);
    define ('CURLOPT_CAINFO', 10065);
    define ('CURLOPT_SSLVERSION', 32);
    define ('CURLOPT_FOLLOWLOCATION', 52);
    define ('CURLOPT_FORBID_REUSE', 75);
    define ('CURLOPT_HTTP_VERSION', 84);
    define ('CURLOPT_MAXREDIRS', 68);
    define ('CURLOPT_ENCODING', 10102);

         define ('CURLINFO_HEADER_SIZE', 2097163);
    define ('CURLINFO_HTTP_CODE', 2097154);
    define ('CURLINFO_HEADER_OUT', 2);      define ('CURLINFO_TOTAL_TIME', 3145731);

    define ('CURLE_SSL_CACERT', 60);
    define ('CURLE_SSL_PEER_CERTIFICATE', 51);
    define ('CURLE_SSL_CACERT_BADFILE', 77);

    define ('CURLE_COULDNT_CONNECT', 7);
    define ('CURLE_OPERATION_TIMEOUTED', 28);
    define ('CURLE_COULDNT_RESOLVE_HOST', 6);

    class CurlEmu
    {
                 private $result;

                 private $responseHeader;

                 private $url;

                 private $options = [];

        protected $isFileUpload = false;

        public function CurlEmu($url)
        {
            $this->url = $url;
        }

        public function setOpt($option, $value)
        {
            $this->options[$option] = $value;
        }

        public function setFileUpload()
        {
            $this->isFileUpload = true;
        }

        public function getInfo($opt = 0)
        {
            if (!$this->result) {
                $this->fetchResult();
            }

            $responseHeaderSize = 0;
            foreach ($this->responseHeader as $header)
                $responseHeaderSize += (strlen($header) + 2);  
            $httpCode = 200;
            if (preg_match('#HTTP/\d+\.\d+ (\d+)#', $this->responseHeader[0], $matches))
                $httpCode = intval($matches[1]);

                         if ($opt == CURLINFO_HEADER_SIZE)
                return $responseHeaderSize;

            if ($opt == CURLINFO_HTTP_CODE)
                return $httpCode;

            return [
                "url" => $this->url,
                "content_type" => "",
                "http_code" => $httpCode,
                "header_size" => $responseHeaderSize,
                "request_size" => 0,
                "filetime" => 0,
                "ssl_verify_result" => null,
                "redirect_count" => 0,
                "total_time" => 0,
                "namelookup_time" => 0,
                "connect_time" => 0,
                "pretransfer_time" => 0,
                "size_upload" => 0,
                "size_download" => 0,
                "speed_download" => 0,
                "speed_upload" => 0,
                "download_content_length" => 0,
                "upload_content_length" => 0,
                "starttransfer_time" => 0,
                "redirect_time" => 0,
                "certinfo" => 0,
                "request_header" => 0
            ];
        }

        public function exec()
        {
            $this->fetchResult();

            $fullResult = $this->result;

            if ($this->getValue(CURLOPT_HEADER, false)) {
                $headers = implode("\r\n", $this->responseHeader);
                $fullResult = $headers . "\r\n" . $this->result;

            }
            if($this->getValue(CURLOPT_HEADERFUNCTION, false) !== false){
                foreach ($this->responseHeader as $headerLine) {
                    call_user_func($this->getValue(CURLOPT_HEADERFUNCTION), $this, $headerLine);
                }
            }
            if ($this->getValue(CURLOPT_RETURNTRANSFER, false) == false) {
                print $fullResult;
            } else {
                return $fullResult;
            }
        }

        private function fetchResult()
        {
            if($this->isFileUpload){
                return $this->fetchResultFileUpload();
            }
             
                         if (!$this->getValue(CURLOPT_CUSTOMREQUEST, false) && $this->getValue(CURLOPT_POST, false)) {
                $method = 'POST';
            } else {
                $method = $this->getValue(CURLOPT_CUSTOMREQUEST, 'GET');
            }

                         if ($method == 'POST') {
                if (is_array($this->getValue(CURLOPT_HTTPHEADER))) {
                    $found = false;
                    foreach ($this->getValue(CURLOPT_HTTPHEADER, array()) as $header) {
                        if (strtolower($header) == strtolower('Content-type: application/x-www-form-urlencoded')) {
                            $found = true;
                        }
                    }

                                         if (!$found) {
                        $headers = $this->getValue(CURLOPT_HTTPHEADER, array());
                        $headers[] = 'Content-type: application/x-www-form-urlencoded';
                        $this->setOpt(CURLOPT_HTTPHEADER, $headers);
                    }
                }
            }

                         if (is_array($this->getValue(CURLOPT_POSTFIELDS))) {
                $content = http_build_query($this->getValue(CURLOPT_POSTFIELDS, array()));
            } else {
                $content = $this->getValue(CURLOPT_POSTFIELDS, "");
            }

                         $timeout = $this->getValue(CURLOPT_TIMEOUT, 60);
            $connectTimeout = $this->getValue(CURLOPT_CONNECTTIMEOUT, 30);

                         if ($connectTimeout > $timeout)
                $timeout = $connectTimeout;

            $headers = $this->getValue(CURLOPT_HTTPHEADER, "");
            if (is_array($headers)) {
                $headers = join("\r\n", $headers);
            }

                         $options = array(
                'http' => array(
                    "timeout" => $timeout,
                    "ignore_errors" => true,
                    'method' => $method,
                    'header' => $headers,
                    'content' => $content
                )
            );

            $options["http"]["follow_location"] = $this->getValue(CURLOPT_FOLLOWLOCATION, 1);

                         if ($this->getValue(CURLOPT_URL, false))
                $this->url = $this->getValue(CURLOPT_URL);


             
            $context = stream_context_create($options);
            $this->result = file_get_contents($this->url, false, $context);

            $this->responseHeader = $http_response_header;
        }

        function fetchResultFileUpload()
        {
            $postdata = $this->getValue(CURLOPT_POSTFIELDS);
            $file = array_shift($postdata);
            $url = $this->getValue(CURLOPT_URL);

            $data = "";
            $boundary = "---------------------".substr(md5(rand(0,32000)), 0, 10);

                         foreach($postdata as $key => $val)
            {
                $data .= "--$boundary\n";
                $data .= "Content-Disposition: form-data; name=\"".$key."\"\n\n".$val."\n";
            }

            $data .= "--$boundary\n";

            $fileContents = file_get_contents($file->filename);
            $data .= "Content-Disposition: form-data; name=\"{$file->postname}\"; filename=\"{$file->postname}\"\n";
            $data .= "Content-Type: " . mime_content_type($file->filename) . "\n";
            $data .= "Content-Transfer-Encoding: binary\n\n";
            $data .= $fileContents."\n";
            $data .= "--$boundary--\n";

            $params = array('http' => array(
                'method' => 'POST',
                'header' => 'Content-Type: multipart/form-data; boundary='.$boundary,
                'content' => $data
            ));

            $ctx = stream_context_create($params);
            $fp = fopen($url, 'rb', false, $ctx);

            if (!$fp) {
                throw new Exception("Problem with $url, $php_errormsg");
            }

            $this->result = @stream_get_contents($fp);
            if ($this->result === false) {
                throw new Exception("Problem reading data from $url, $php_errormsg");
            }
            $this->result;
            $this->responseHeader = $http_response_header;
        }

        private function getValue($value, $default = null)
        {
            if (isset($this->options[$value]) && $this->options[$value]) {
                return $this->options[$value];
            }
            return $default;
        }

        public function errNo()
        {
            return 0;
        }

        public function error()
        {
            return "";
        }

        public function close()
        {

        }
    }

    class CURLFile extends stdClass
    {
        public function __construct($filename, $mimetype = '', $postname = '')
        {
            $this->filename = $filename;
            $this->mimetype = $mimetype;
            $this->postname = $postname;
        }
    }

    function curl_init($url = null)
    {
        return new CurlEmu($url);
    }

    function curl_setopt($ch, $option, $value)
    {
        $ch->setOpt($option, $value);
    }

    function curl_exec($ch)
    {
        return $ch->exec();
    }

    function curl_getinfo($ch, $option = 0)
    {
        return $ch->getInfo($option);
    }

    function curl_errno($ch) {
        return $ch->errNo();
    }

    function curl_error($ch) {
        return $ch->error();
    }

    function curl_close($ch) {
        return $ch->close();
    }

    function curl_setopt_array($ch, $options) {
        foreach ($options as $option => $value) {
            curl_setopt($ch, $option, $value);
        }
    }

     
    function curl_file_create($filename, $mimetype = '', $postname = '')
    {
        return new CURLFile($filename, $mimetype, $postname);
    }
}