_me = obj_list_conference_item.prototype;
function obj_list_conference_item(){};

_me.__constructor = function(aData) {

	this.__aData = aData;
	this.__aData.start = IcewarpDate.julian(aData.EVNSTARTDATE, Math.max(aData.EVNSTARTTIME, 0));
	this.__aData.end = IcewarpDate.julian(aData.EVNENDDATE, Math.max(aData.EVNENDTIME, 0));

	var out = clone(aData, true),
		org = ((out.EVN_ORGANIZER || out.EVNORGANIZER)?MailAddress.splitEmailsAndNames(out.EVN_ORGANIZER || out.EVNORGANIZER):[{name:out.EVNOWNERNAME, email:out.EVNOWNEREMAIL}])[0];

	//ouput
	out.date = this.__date();
	out.name = (org.name || dataSet.get('main',['fullname']) || sPrimaryAccount).entityify();
	out.avatar = '<span style="background-image: url(\''+getAvatarURL(org.email || 'blank') +'\')"></span>';
	out.modified_name = (org.name || org.email || '').entityify();
	out.EVNTITLE = out.EVNTITLE || getLang('EVENT_VIEW::NOTITLE');

	var att_data = {};
	if (aData.ATTACHMENTS && aData.ATTACHMENTS.length) {
		aData.ATTACHMENTS[0].PARAMS[0].VALUE.split('&').forEach(function(part) {
			var tmp = part.split('=');
			att_data[tmp[0]] = decodeURIComponent(decodeURIComponent(tmp[1]));
		});
	}

	if (aData.EVNCLASS === 'J' && aData.EVNFLAGS & 1024 && (out.expiration = this.__expiration(att_data.expire_at))) {
		addcss(this._main, 'has-recording');
		out.thumbnail_url = att_data.thumbnail_url;
	}

	var aMenu = [];
	if (!aData.bNoMenu) {
		if (aData.EVNCLASS === 'J') {
			aMenu = [
				{
					css: 'ico2 conference',
					title: 'EVENT::JOINCONFERENCE',
					arg: [join]
				},
				aData.EVNFLAGS & 1024 && {
					css: 'ico2 link',
					title: 'POPUP_ITEMS::COPY_LINK',
					arg: [function() {

						var link = decodeURIComponent(aData.EVNURL).split(';')[0],
							input = mkElement('input', {style:{opacity:0}, value:link});

						document.body.appendChild(input);
						input.select();
						document.execCommand('copy');
						input.parentElement.removeChild(input);
						gui.notifier && gui.notifier._value({type: 'clipboard_link'});
					}]
				},
				aData.EVNFLAGS & 1024 && {
					css: 'ico2 share_folder',
					title: 'POPUP_ITEMS::SHARE',
					arg: [function() {
						gui._create('sharing', 'frm_share_recording', '', '', aData);
					}]
				},
				{
					css: 'ico2 add_calendar',
					title: 'EVENT::RESCHEDULE',
					arg: [function() {
						WMItems.list(aData, null, null, null, [function(aResponse) {
							var data = aResponse[aData.aid][aData.fid][WMItems.__clientID(aData.iid)];
							Item.openwindow([sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')], {
								conference: true,
								EVNTITLE: data.EVNTITLE,
								CONTACTS: data.CONTACTS // TODO!!!!!!!!!!!!!!!!!
							});
						}])
					}]
				}
			].filter(Boolean);
		} else {
			aMenu = [
				{
					css: 'ico2 edit',
					title: 'POPUP_ITEMS::EDIT',
					arg: [function() {
						this.__edit(aData);
					}.bind(this)]
				},
				{
					css: 'ico2 link',
					title: 'POPUP_ITEMS::COPY_LINK',
					arg: [function() {

						var link = (new wm_conference(aData.EVNMEETINGID, aData)).getLink(),
							input = mkElement('input', {style:{opacity:0}, value:link});

						document.body.appendChild(input);
						input.select();
						document.execCommand('copy');
						input.parentElement.removeChild(input);
						gui.notifier && gui.notifier._value({type: 'clipboard_link'});
					}]
				},
				{
					css: 'ico2 delete color2',
					title: 'POPUP_ITEMS::DELETE',
					arg: [Item.remove, [[sPrimaryAccount, aData.EVNFOLDER || aData.fid, [WMItems.__clientID(aData.EVN_ID)]], false, null, '', '',
						[function(bOK){
							if (bOK)
								this._parent._fire(WMItems.__clientID(aData.EVN_ID), 'delete');
						}.bind(this)]
					]]
				}
			];
		}
	}

	this._draw('obj_list_conference_item', 'main', {
		item: out,
		meet: aData.EVNCLASS !== 'J',
		menu: aMenu.length
	});

	function join() {
		var id = aData.iid;
		var date;
		if (Is.Defined(aData.EVNRCR_ID) && Is.Defined(aData.EVNSTARTDATE)) {
			date = aData.EVNSTARTDATE;
			id = id.split('|')[0];
		}
		WMItems.list({
			aid: aData.aid,
			fid: aData.fid,
			iid: id,
			date: date
		},null,null,null,[function(aResponse) {
			storage.library('wm_conference');
			wm_conference.get(aData.EVNMEETINGID, aResponse[aData.aid][aData.fid][WMItems.__clientID(aData.EVN_ID)]).join();
		}]);
	}

	//// CLICKs ////
	if(aData.EVNCLASS === 'J') {
		if (this.play) {
			this.play._onclick = function() {
				window.open(decodeURIComponent(aData.EVNURL).split(';')[0], '_blank');
			};
		}
	} else {
		this.meet._onclick = join;
		this.__badge();
	}

	if (aMenu.length) {
		this.menu._onclick = this._main.oncontextmenu = function(e) {
			var context = gui._create("cmenu", "obj_context", '', '', this);
			gui.cmenu._fill(aMenu);
			gui.cmenu._place(e.clientX, e.clientY);
			this._main.classList.add('active');
			context._onclose = function() {
				this._main.classList.remove('active');
			}.bind(this);

			e.preventDefault();
			e.stopPropagation();
			e.stopImmediatePropagation();
		}.bind(this);
	}

	this._add_destructor('__destructTimers');
};

_me.__duration = function (seconds) {
	var hours = Math.floor(seconds / 3600);
	var minutes = Math.floor((seconds - (hours * 3600)) / 60);
	seconds = Math.floor(seconds - (hours * 3600) - (minutes * 60));

	if (hours < 10) { hours = '0' + hours; }
	if (minutes < 10) { minutes = '0' + minutes; }
	if (seconds < 10) { seconds = '0' + seconds; }
	return (+hours ? hours + ':' : '') + minutes + ':' + seconds;
};

_me.__expiration = function (expiresAt) {
	var diff = Math.floor(new IcewarpDate(expiresAt * 1000).diff(new IcewarpDate()) / 1000);
	var expiration;
	if (diff > 60 * 60 * 24) {
		expiration = getLang('CONFERENCE::DAYS', [Math.floor(diff / 60 / 60 / 24)]);
	} else if (diff > 60 * 60) {
		expiration = getLang('CONFERENCE::HOURS', [Math.floor(diff / 60 / 60)]);
	} else if (diff > 60) {
		expiration = getLang('CONFERENCE::MINUTES', [Math.floor(diff / 60)]);
	} else if (diff > 0) {
		expiration = getLang('CONFERENCE::SECONDS', [Math.floor(diff)]);
	} else {
		return false;
	}
	return getLang('CONFERENCE::EXPIRATION', [expiration]);
};

_me.__edit = function(aData) {
	Item.openwindow([sPrimaryAccount, aData.EVNFOLDER || aData.fid, WMItems.__clientID(aData.EVN_ID)], null, aData, void 0, [function(bOk, aData) {
		if (bOk && gui.socket){
			var f = dataSet.get('folders', [sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')]);
			f && gui.socket.api._notify({
				ACTION: 'edit',
				TYPE: 'item',
				ITEM: aData.id,
				FOLDER: f.RELATIVE_PATH,
				'FOLDER-TYPE': f.TYPE,
				EMAIL: sPrimaryAccount,
				'ITEM-TYPE': 'E'
			});
		}
	}]);
}

_me.__badge = function(){

	var t = new IcewarpDate().second(0).millisecond(0);

	//starts in...
	if ((this.__aData.start.isToday() && this.__aData.start.isAfter(t)) || this.__aData.start.isTomorrow()){
		//in 60min
		if (t.unix()+3600 >= this.__aData.start.unix()){

			var elm = this._getAnchor('badge');

			var fce = function(){
				var t = new IcewarpDate();

				var sec = Math.max(this.__aData.start.unix() - t.unix(), 0);
				if (sec){
					elm.textContent = getLang('CONFERENCE::MIN_TO_GO',[Math.ceil(sec/60)]);
					addcss(elm, 'show');
				}
				else{
					clearInterval(this.__badgeInterval);
					removecss(elm, 'show');

					//to in progress state
					this.__badge();
				}

			}.bind(this);

			//set interval
			this.__badgeInterval && clearInterval(this.__badgeInterval);
			this.__badgeInterval = setInterval(fce,	10000);
			fce();
		}
		//more then 60min
		else{
			//set timer to start count
			this.__badgeTimer && clearTimeout(this.__badgeTimer);
			this.__badgeTimer = setTimeout(function(){
				this.__badge();
			}.bind(this),
			(this.__aData.start.unix() - t.unix() + 5) * 1000);
		}
	}
	else
	//running
	if (this.__aData.start.isSameOrBefore(t) && this.__aData.end.isSameOrAfter(t.clone().add('second', -10))){
		var t = new IcewarpDate(),
			elm = this._getAnchor('badge');
			elm.textContent = getLang('TASK::IN_PROGRESS');
			addcss(elm, 'show');
			addcss(elm, 'in_progress');

		this.__badgeTimer && clearTimeout(this.__badgeTimer);
		this.__badgeTimer = setTimeout(function(){
			this.__badge();
		}.bind(this), (this.__aData.end.unix() - t.unix() + 5) * 1000);
	}
	else{
		removecss(this._getAnchor('badge'), 'show');

		//For Upcoming only
		if (this._parent.__options && this._parent.__options.order == 'asc' && this.__aData.end.isBefore(t)){
			this._parent._remove(this, 2000);
		}
	}

};

_me.__date = function(){

	var sDate = '';

	if (this.__aData.EVNSTARTTIME<0){
		if (this.__aData.EVNSTARTDATE<this.__aData.EVNENDDATE-1){
			sDate = this.__aData.start.format('L') + ' - ' + this.__aData.end.format('L');
		}
		else{
			sDate = CalendarFormatting.normalWithWeekDay(this.__aData.start);
		}
	}
	else{
		sDate = CalendarFormatting.normalWithWeekDayAndTime(this.__aData.start);
		if (this.__aData.EVNSTARTDATE<this.__aData.EVNENDDATE){
			sDate += ' - ' + CalendarFormatting.normalWithWeekDayAndTime(this.__aData.end);
		}
		else{
			sDate += ' - ' + this.__aData.end.format('LT');
		}
	}

	return sDate;
};

_me.__destructTimers = function(){
	this.__badgeInterval && clearInterval(this.__badgeInterval);
	this.__badgeTimer && clearTimeout(this.__badgeTimer);
};

_me.__update = function(){
	var date, id = this.__aData.iid;
	if (~id.indexOf('|')) {
		id = this.__aData.iid.split('|');
		date = id[1];
		id = id[0];
	}
	var aItemsInfo = {aid:this.__aData.aid, fid:this.__aData.fid, iid:id, date: date, values:['EVN_ID', 'EVNTITLE', 'EVNSTARTDATE', 'EVNSTARTTIME', 'EVNENDDATE', 'EVNENDTIME', 'OSD', 'EVNCLASS', 'EVNMEETINGID', 'EVNORGANIZER', 'EVNRCR_ID']};

	WMItems.list(aItemsInfo,'','','',[function(aData){
		if (aData && (aData = aData[this.__aData.aid]) && (aData = aData[this.__aData.fid]) && (aData = aData[id])){
			for (var k in aData)
				this.__aData[k] = aData[k];

			this.__constructor(this.__aData);
		}

	}.bind(this)]);

};
