_me = frm_whatsnew.prototype;
function frm_whatsnew() { };

_me.__constructor = function () {
	storage.library('gw_others');
	var me = this;

	this._size(632, 715, true);
	this._modal(true);
	this._dockable(false);
	this._resizable(false);

	this._create('loader', 'obj_loader');

	this._draw('frm_whatsnew', 'main');

	this.__checkPosition();

	var pages = [
		{
			name: 'recording'
		},
		{
			name: 'conferences',
			guest: true
		},
		{
			name: 'documents',
			guest: true
		},
	].filter(function(page) {
		if (!sPrimaryAccountGUEST || page.guest) {
			return true;
		}
	});

	pages.forEach(function(page) {
		var tab = me.maintab._create(page.name, 'obj_tab', '', 'nopadding');
		tab._value(getLang('WHATSNEW::' + page.name), true);
		tab._onactive = function (bFirstTime) {
			if (bFirstTime) {
				this._draw('frm_whatsnew_body', 'main', {
					heading: getLang('WHATSNEW::' + page.name + '_HEADING'),
					description: getLang('WHATSNEW::' + page.name + '_DESCRIPTION'),
					image: './client/skins/default/images/whatsnew/' + page.name + '.png'
				});
			}

			if (pages[pages.length - 1].name === this._name) {
				me.btn_next._value('WHATSNEW::START');
				removecss(me.btn_next._main, 'ico2');
			}
			else {
				me.btn_next._value('COMMON::NEXT');
				addcss(me.btn_next._main, 'ico2');
			}
		};
	});

	if (pages.length === 1) {
		addcss(this.maintab._main, 'notabs');
	}

	this._create('btn_next', 'obj_button', 'footer', 'color1 simple');
	this.btn_next._value('COMMON::NEXT');
	this.btn_next._onclick = function () {
		if (this.maintab._value() === pages[pages.length - 1].name)
			this._close();
		else
			this.maintab._next();
	}.bind(this);

	this.maintab[this.maintab._value()]._onactive(true);

	this.loader._destruct();
};

_me._onclose = function () {
	window.removeEventListener('message', this._messageHandler);
	var tmp = GWOthers.getItem('LOGIN_SETTINGS', 'version').split('.');
	Cookie.set(['whatsnew'], tmp[0] + '.' + tmp[1] + '.' + tmp[2]);
	return true;
};