_me = frm_moderators.prototype;
function frm_moderators() { };

_me.__constructor = function (users, callback) {
	var me = this;

	this._title('EVENT::MANAGE');
	this._defaultSize(-1, -1, 600, 800);
	this._modal(true);
	this._resizable(false);

	this._create('_scrollbar', 'obj_scrollbar');
	this._scrollbar._scrollbar(this._getAnchor('main'), this._getAnchor('main').parentNode);

	this._draw('frm_moderators', 'main');

	var moderator_icon = '<span class="icon moderator"></span>',
		remove_icon = '<span class="icon remove"></span>';
	this._getAnchor('description').innerHTML = getLang('EVENT::MANAGE_DESCRIPTION') + '<br />' + getLang('EVENT::MANAGE_DESCRIPTION2', [
		moderator_icon,
		moderator_icon,
		remove_icon
	]);

	// FILTER
	this.filter._onchange = function () {
		var value = this._value().trim().toLowerCase();
		[].forEach.call(me.x_users.children, function (div) {
			div.classList.toggle('hidden', value && !~div.querySelector('.name').textContent.toLowerCase().indexOf(value));
		});
		[].forEach.call(me.x_moderators.children, function (div) {
			div.classList.toggle('hidden', value && !~div.querySelector('.name').textContent.toLowerCase().indexOf(value));
		});
	};

	// SUGGEST
	this.x_address_book_icon._onclick = function () {
		gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, void 0, void 0, true);
		gui.address_book._modal(true);
	};

	this.x_suggest._single = true;
	this.x_suggest._itemClass = ['C'];

	this.x_suggest._disobeyEvent('change', [this.x_suggest, '_checksize']);
	this.x_suggest._checksize = function () { };
	this.x_suggest._placeholder(getLang('ATTENDEES::QUICK_ADD'));
	this.x_suggest._onsubmit = function () {
		if (!this._checkError.length) {
			var tmp = MailAddress.splitEmailsAndNames(this._value());
			this._value('');
			if (tmp && tmp[0] && tmp[0].email) {
				me.__onAddNewFromAddressbook(true, [[MailAddress.createEmail(tmp[0].name, tmp[0].email)]]);
			}
		}
	};
	this.x_suggest.__minWidth = 400;
	this.x_suggest._onmouseselect = this.x_suggest._onsubmit;
	this.x_suggest._restrict([function (v) {
		if (v === '') return true;
		var tmp = MailAddress.splitEmailsAndNames(v);
		if (tmp && tmp[0] && tmp[0].email) {
			return Is.Email(tmp[0].email);
		}
		return false;
	}]);
	this.x_suggest._main.appendChild(mkElement('div', {
		className: 'add',
		onclick: function () {
			gui._create('address_book', 'frm_addaddress', '', '', [me, '__onAddNewFromAddressbook'], ['ADDRESS_BOOK::SELECTED_ADDRESSES'], void 0, void 0, void 0, void 0, true);
			gui.address_book._modal(true);
		}
	}));

	// LISTS
	this.x_users = this._getAnchor('users');
	this.x_users.__users = [];
	this.x_moderators = this._getAnchor('moderators');
	this.x_moderators.__users = [];

	this.x_users.onclick = this.x_moderators.onclick = function (e) {
		var i = e.target.parentNode.id.substr((me._pathName + '.list/').length);
		if (i === '') {
			return;
		}

		if (e.target.classList.contains('remove')) {
			this._removeUser(i);
		} else if (e.target.classList.contains('moderator')) {
			this._moderator(i);
		}
	};

	this.x_users._fill = this.x_moderators._fill = function () {
		var out = mkElement('div');

		this.__users = this.__users.sort(function (a, b) {
			return (a.role === 'G') ? -1 : (b.role === 'G');
		});

		for (var i = 0; i < this.__users.length; i++) {
			if (this.__users[i].action === 'remove')
				continue;

			var css = [this.__users[i].css];
			if (this.__users[i].status)
				css.push('status_' + this.__users[i].status);

			if (this.__users[i].role)
				css.push('role_' + this.__users[i].role);

			if (this.__users[i].moderator)
				css.push('is-moderator');

			var name = this.__users[i].email === sPrimaryAccount ? getLang('COMMON::YOU') : (this.__users[i].name || this.__users[i].email).escapeHTML();
			out.appendChild(mkElement('div', {
				id: me._pathName + '.list/' + i,
				className: css.filter(Boolean).join(' '),
				unselectable: 'on',
				title: this.__users[i].email,
				innerHTML: '<div class="img" style="background-image: url(\'' + getAvatarURL(this.__users[i].email) + '\')"></div><div class="name">' + name + '</div><div class="moderator">' + getLang('EVENT::MODERATOR') + '</div>' + (this.__users[i].email === sPrimaryAccount ? '' : '<div class="remove"><div class="icon"></div></div>'),
			}));
		}

		this.innerHTML = out.innerHTML;
	};

	this.x_users._addUser = function (aInfo) {
		if (aInfo.email && aInfo.email.indexOf('[') === 0) {
			(new wm_tools()).distrib({
				name: aInfo.email
			}, [this, '_addGroup', [aInfo.role]]);
		} else {
			aInfo.email = aInfo.email.toLowerCase();
			for (var i = this.__users.length - 1; i > -1; i--)
				if (this.__users[i].email === aInfo.email && this.__users[i].action !== 'remove')
					return false;
			for (var i = me.x_moderators.__users.length - 1; i > -1; i--)
				if (me.x_moderators.__users[i].email === aInfo.email && me.x_moderators.__users[i].action !== 'remove')
					return false;

			aInfo.action = 'new';
			this.__users.push(aInfo);
			this._fill();
		}
	};

	this.x_users._addGroup = function (aData, sRole) {
		for (var i in aData) {
			aData[i].role = sRole;
			this._addUser(aData[i]);
		}
	};

	this.x_users._moderator = this.x_moderators._moderator = function (i) {
		if (this.__users[i].moderator) {
			this.__users[i].moderator = false;
			if (this.__users[i].action !== 'new') this.__users[i].action = 'edit';

			me.x_users.__users.push(this.__users[i]);
			me.x_moderators.__users.splice(i, 1);
		} else {
			this.__users[i].moderator = true;
			if (this.__users[i].action !== 'new') this.__users[i].action = 'edit';

			me.x_moderators.__users.push(this.__users[i]);
			me.x_users.__users.splice(i, 1);
		}

		me.x_moderators._fill();
		me.x_users._fill();
	};

	this.x_users._removeUser = this.x_moderators._removeUser = function (i) {
		if (this.__users[i].action === 'new')
			this.__users.splice(i, 1);
		else
			this.__users[i].action = 'remove';

		this._fill();
	};

	for (var i in users) {
		if (users[i].moderator) {
			this.x_moderators.__users.push(users[i]);
		} else {
			this.x_users.__users.push(users[i]);
		}
	}

	this.x_users._fill();
	this.x_moderators._fill();

	// BUTTONS
	this.x_btn_ok._value('FORM_BUTTONS::SAVE');
	this.x_btn_ok._onclick = function () {
		this._disabled(true);
		callback(me.x_moderators.__users.concat(me.x_users.__users));
		this._parent._destruct();
	};

	this.x_btn_cancel._onclick = function () {
		this._parent._destruct();
	};
};

_me.__onAddNewFromAddressbook = function (bOK, aAddresses) {
	if (bOK && aAddresses[0]) {
		var tmp;

		for (var i in aAddresses[0]) {
			tmp = MailAddress.splitEmailsAndNames(aAddresses[0][i]);

			if (typeof tmp[0] === 'object') {
				tmp[0].role = 'Q';
				this.x_users._addUser(tmp[0]);
			}
		}
	}
};