function frm_jitsi() {};

frm_jitsi.prototype.__constructor = function () {
	if (!sPrimaryAccountCONFERENCE) {
		return;
	}

	this._draw('frm_jitsi');
	this.focus._onclick = this._focus.bind(this);
	this.leave._onclick = this._close.bind(this);

	gui._obeyEvent('conference_started', [this, '_updateGUI']);
	gui._obeyEvent('conference_ended', [this, '_updateGUI']);

	addEventListener('message', function (event) {
		if (event.data && event.data.type === 'conference') {
			wm_conference.get(event.data.cid).receiveMessage(event);
		}
	}, false);

	var last_running_conference_timstamp = localStorage.getItem('last_running_conference_timestamp');
	if (last_running_conference_timstamp && last_running_conference_timstamp > (+new Date() - 10000)) {
		this.__brc = this._bindRunningConference.bind(this);
		addEventListener('click', this.__brc);
		addEventListener('keypress', this.__brc);
	}

	addEventListener('click', function (event) {
		var tmp;

		if (event.target.tagName === 'A' && (tmp = event.target.href.match(wm_conference.linkRegExp))) {
			event.preventDefault();
			event.stopPropagation();
			event.stopImmediatePropagation();

			wm_conference.get(tmp[2] + '_' + tmp[1]).join();
		}
	});
};

frm_jitsi.prototype._bindRunningConference = function () {
	removeEventListener('click', this.__brc);
	removeEventListener('keypress', this.__brc);
	this.window = window.open('', 'jitsi_' + sPrimaryAccount);
	try {
		if (this.window.document.body.innerHTML) {} else {
			this.window.close();
			this.window = null;
		}
	} catch (e) {}

	if (this.window) {
		var id = this.window.location.toString().split('/').pop().replace('#', '') + '_' + this.window.location.hostname;
		var conference = wm_conference.get(id);
		conference.window = this.window;

		conference.isRunning = true;
		dataSet.add('main', ['conference'], id);
		conference.postMessage({
			event: 'load'
		});
		conference.getDetail(function () {
			gui.__exeEvent('conference_started');
		});
	}
};

frm_jitsi.prototype._focus = function () {
	wm_conference.get(dataSet.get('main', ['conference'])).focus();
	gui.frm_main._selectView({
		aid: sPrimaryAccount,
		fid: '__@@VIRTUAL@@__/__@@MEETINGS@@__'
	});
	gui.frm_main.main._view('progress');
};

frm_jitsi.prototype._close = function () {
	wm_conference.get(dataSet.get('main', ['conference'])).close();
};

frm_jitsi.prototype._updateGUI = function () {
	var conferenceId = dataSet.get('main', ['conference']);
	if (!conferenceId) {
		return;
	}
	var conference = wm_conference.get(conferenceId);

	this.focus.__eIN.value = getLang('CONFERENCE::CONFERENCE_IN_PROGRESS', [conference.data.subject || conference.id || getLang('CONFERENCE::TITLE')]);
};
