_me = frm_collaboration.prototype;

function frm_collaboration() {};

_me.__constructor = function (aValues) {
	var me = this;

	this._size(700, window.innerHeight < 800 ? window.innerHeight : 'auto', true);
	this._draw('obj_share_collaboration', 'main_content', {});

	function processing(disable) {
		me.enabled._disabled(disable);
		me.allowed_editing._disabled(disable);
		me.password_protected._disabled(disable);
		me.password._disabled(disable);
		me.save_password._disabled(disable);
	}

	this.enabled._onclick = function () {
		var enabled = me.enabled._checked();
		var editable = me.allowed_editing._value();
		var protected = me.password_protected._checked();
		var password = me.password._value();
		processing(true);
		TeamChatAPI[enabled ? 'filesUninvite' : 'filesInvite'].call(TeamChatAPI, {
			id: aValues.EVN_ID,
			editable: editable,
			password: protected ? password : ''
		}, {
			success: function (response) {
				processing(false);
				me.enabled._value(!!response.inviteticket);
				aValues.INVITETICKET = response.inviteticket;
				me.__addCloseButton();
			},
			error: function () {
				gui.notifier._value({
					type: 'alert',
					args: {
						header: '',
						text: 'ALERTS::FILE_LOCKED_EDIT'
					}
				});
				processing(false);
			}
		});
		return false;
	};

	this.enabled._onchange = function (event, enabled) {
		me._getAnchor('editing').classList[enabled ? 'remove' : 'add']('disabled');
		me._getAnchor('password').classList[enabled ? 'remove' : 'add']('disabled');
		me._getAnchor('share').classList[enabled ? 'remove' : 'add']('disabled');
	};

	this.allowed_editing._onclick = function () {
		var editable = me.allowed_editing._value();
		var protected = me.password_protected._checked();
		var password = me.password._value();
		processing(true);
		TeamChatAPI.filesInvite({
			id: aValues.EVN_ID,
			editable: !editable,
			password: protected ? password : ''
		}, {
			success: function () {
				processing(false);
				me.allowed_editing._value(!editable);
				me.__addCloseButton();
			},
			error: function () {
				processing(false);
			}
		});
		return false;
	};

	this.password_protected._onclick = function () {
		var editable = me.allowed_editing._value();
		var protected = me.password_protected._checked();
		var password = me.password._value();
		if (protected || password) {
			processing(true);
			TeamChatAPI.filesInvite({
				id: aValues.EVN_ID,
				editable: editable,
				password: protected ? '' : password
			}, {
				success: function () {
					processing(false);
					me.password_protected._value(!protected);
					me._getAnchor('password_protected').classList[!protected && password ? 'remove' : 'add']('hidden');
					me.__addCloseButton();
				},
				error: function () {
					processing(false);
				}
			});
			return false;
		}
	};

	this.password_protected._onchange = function (event, enabled) {
		var sharing_enabled = me.enabled._checked();
		me._getAnchor('password_container').classList[!enabled || !sharing_enabled ? 'add' : 'remove']('hidden');
		me._getAnchor('password_protected').classList[(enabled && me.password._value()) ? 'remove' : 'add']('hidden');
	};

	this.password._onkeydown = function (e) {
		if (e.keyCode === 13) {
			me.save_password._onclick();
			me.password._focus();
		}
	};

	this.password.__setMask({
			'toggle': ['', getLang('COMMON::SHOW')]
		},
		[function () {
			if (me.password.__eIN.getAttribute('type') === 'text') {
				me.password.__eIN.setAttribute('type', 'password');
			} else {
				me.password.__eIN.setAttribute('type', 'text');
			}
		}]);

	this.password._onchange = function () {
		if (me.__resetSavePasswordTimeout) {
			clearTimeout(me.__resetSavePasswordTimeout);
			me.__resetSavePassword();
		}

		me.save_password._main.classList[(me.password._value() === (aValues.EVNDOCPASS || '')) ? 'add' : 'remove']('hidden');
	};

	this.__resetSavePassword = function () {
		if (me.save_password) {
			me.save_password._disabled(false);
			me.save_password._value('FORM_BUTTONS::SAVE');
			me.save_password._main.classList.add('hidden');
		}
	};

	this.save_password._onclick = function () {
		var editable = me.allowed_editing._value();
		var password = me.password._value();
		processing(true);
		TeamChatAPI.filesInvite({
			id: aValues.EVN_ID,
			editable: editable,
			password: password
		}, {
			success: function () {
				processing(false);
				me.save_password._disabled(true);
				me.save_password._value('FORM_BUTTONS::SAVED');
				me.__resetSavePasswordTimeout = setTimeout(me.__resetSavePassword.bind(me), 2000);
				me._getAnchor('password_protected').classList[password ? 'remove' : 'add']('hidden');
				aValues.EVNDOCPASS = password;
				me.__addCloseButton();
			},
			error: function () {
				processing(false);
			}
		});
	};

	if (Item.officeSupport(aValues.EVNTITLE, true)) {
		this._getAnchor('editing').classList.remove('hidden');
	}

	this.enabled._value(!!aValues.INVITETICKET);
	this.enabled._onchange(void 0, !!aValues.INVITETICKET);
	this.allowed_editing._value(aValues.EVNDOCEDITABLE === '1');
	if (aValues.EVNDOCPASS_PLAIN) {
		aValues.EVNDOCPASS = aValues.EVNDOCPASS_PLAIN;
	}
	if (aValues.EVNDOCPASS) {
		this.password._value(aValues.EVNDOCPASS.unentityify());
		this._getAnchor('password_container').classList.remove('hidden');
	}
	this.password_protected._value(!!aValues.EVNDOCPASS);
	this._getAnchor('password_protected').classList[aValues.EVNDOCPASS ? 'remove' : 'add']('hidden');

	this.reset_link._onclick = function() {
		gui._create('confirm', 'frm_confirm', '', '', [function() {
			WMItems.action({
				aid: aValues.aid,
				fid: aValues.fid,
				iid: aValues.EVN_ID
			}, 'collaboration_reset', [function (_, response) {
				if(me.__callback && me.__callback[0]) {
					me.__callback[0] = me.__callback[0].bind(null, response.IQ[0].RESULT[0].ID[0].VALUE);
				}
				me._destruct();
			}]);
		}], 'COLLABORATION::RESET_LINK', 'COLLABORATION::RESET_LINK_HELPER');
	};
};