const generateYearsAhead = 5;
const allowedTypes = [/^public$/i];

const fs = require('fs');
const path = require('path');
const ical = require('date-holidays-ical')();

fs.writeFileSync(path.join(__dirname, './data.js'), fs.readFileSync(path.join(__dirname, './node_modules/date-holidays/src/data.js'), 'utf-8').replace(/export const /, 'exports.'));
const DateHolidaysData = require(path.join(__dirname, './data.js')).data.holidays;

const supportedCountries = Object.keys(ical.query());
const supportedCountriesMap = {
    IR: 'FA',
    GB: 'UK',
    ES: 'SP'
};

const debugFilePath = path.join(__dirname, '.debug');
fs.writeFileSync(debugFilePath, '');

let done = 0; let donePercent = 0;
supportedCountries.forEach(country => {
    if (!DateHolidaysData[country] || !DateHolidaysData[country].days) {
        return console.log('Missing data for', country);
    }

    ical.init(country, void 0, void 0, {
        timezone: 'Etc/UTC'
    });
    const days = DateHolidaysData[country].days || {};
    const name = DateHolidaysData[country].names.en;
    const origName = DateHolidaysData[country].names[DateHolidaysData[country].langs[0]] || DateHolidaysData[country].names[DateHolidaysData[country].langs[1]];
    country = (supportedCountriesMap[country] || country);

    let oldHolidays;
    let mergedFilename;
    let oldICS;
    let oldICSFile = '';

    const oldCountryFolder = path.join(__dirname, '..', country.toLowerCase());
    if (fs.existsSync(oldCountryFolder)) {
        oldICS = fs.readdirSync(oldCountryFolder).filter(elm => elm.match(/\.ics$/ig))[0];
    } else {
        fs.mkdirSync(oldCountryFolder, { recursive: true });
        fs.writeFileSync(path.join(oldCountryFolder, 'info.dat'), country + '\n' + (origName || (name + ' holidays')) + '\n' + name);
    }

    if (oldICS) {
        oldHolidays = fs.readFileSync(path.join(oldCountryFolder, oldICS), 'utf-8');
        oldICSFile = oldICS;
        mergedFilename = oldICS;
    } else {
        oldHolidays = '';
        mergedFilename = country.toLowerCase() + '.ics';
    }

    const thisYear = +new Date().getFullYear();
    for (let i = 0; i <= generateYearsAhead; i++) {
        oldHolidays += ical.calendar(thisYear + i, {});
    }

    let newHolidays = 'BEGIN:VCALENDAR';
    const added = {};
    const skipped = {};
    (oldHolidays.match(/BEGIN:VEVENT(.*\r?\n?)+?END:VEVENT/g) || []).forEach(vevent => {
        let type = '';
        try {
            type = vevent.match(/DESCRIPTION(.*\r?\n?)/)[0].replace('DESCRIPTION:', '').trim();
        } catch(e) {
            try {
                type = vevent.match(/LOCATION:type=.*?\n/)[0].replace('LOCATION:type=', '').trim();
            } catch(e) {}
        }
        const name = vevent.match(/SUMMARY(.*\r?\n?)/)[0].replace('SUMMARY:', '').trim();
        const date = vevent.match(/DTSTART.*?(\d+)/)[1].trim();
        const monthDay = date.substring(4);

        // not allowed
        if (!allowedTypes.some(allowed => type.match(allowed))) {
            skipped[type] = skipped[type] || {};
            skipped[type][name] = (skipped[type][name] || 0) + 1;
            return;
        }

        // duplicates
        if (newHolidays.match(new RegExp('DTSTART.*' + date)) || newHolidays.match(new RegExp('BEGIN:VEVENT((?!BEGIN).|\n)*?(.*YEARLY)((?!BEGIN).|\n)*?DTSTART.*' + monthDay + '\n(.|\n)*?END:VEVENT')) || newHolidays.match(new RegExp('BEGIN:VEVENT((?!BEGIN).|\n)*?DTSTART.*' + monthDay + '\n((?!BEGIN).|\n)*?YEARLY((?!BEGIN).|\n)*?END:VEVENT'))) {
            skipped['duplicate'] = skipped['duplicate'] || {};
            skipped['duplicate'][name] = (skipped['duplicate'][name] || 0) + 1;
            return;
        }

        // make recurrent
        if (days[monthDay.match(/(..?)/g).join('-')]) {
            vevent = vevent.replace(/RRULE:FREQ=YEARLY.*?\n/, '').replace('END:VEVENT', 'RRULE:FREQ=YEARLY\nEND:VEVENT');
        }

        added[type] = added[type] || {};
        added[type][name] = (added[type][name] || 0) + 1;
        newHolidays += '\n\n' + vevent.replace(/T000000Z/g, '');
    });

    if (!Object.keys(added).length && !Object.keys(skipped).length) {
        return fs.appendFile(
            debugFilePath,
            country + ': Skipped - no new holidays\n',
            () => {}
        );
    }

    newHolidays = (newHolidays + '\n\n' + 'END:VCALENDAR').replace(/(\r?\n){3,}/g, '\n\n');

    let percent = Math.ceil(100 / supportedCountries.length * ++done);
    if (!(percent % 10) && percent != donePercent) {
        console.log(percent + '%');
        donePercent = percent;
    }
    
    fs.writeFile(
        path.join(oldCountryFolder, mergedFilename),
        newHolidays,
        () => {
            fs.appendFile(
                debugFilePath,
                country + ': ' + JSON.stringify({
                    OldFile: oldICSFile,
                    Added: added,
                    Skipped: skipped
                }, '', '\t') + ',\n',
                () => {}
            );
        }
    );
});