unit GeneralAPIUnit;

interface

Uses  SysUtils, Windows;

Type  ApiCall = Function(A,B,C,D,E,F,G:PAnsiChar):PAnsiChar; cdecl;
      ApiFree = Procedure(A:Pointer); cdecl;


Type
  THeaderIndexList = Array Of Record
    Header: AnsiString;
    Index: NativeInt;
  End;



Var gAPIDll : THandle = 0;
    globalAPICall: ApiCall = Nil;
    gAPIFree: ApiFree = Nil;

    Function CallAPI(P1,P2,P3:AnsiString;P4 : AnsiString='';P5 : AnsiString='';P6 : AnsiString='';P7 : AnsiString=''):AnsiString;
    Function APIInit: Boolean;
    Procedure APIDone;

    Function GWLoginAs(GWInstance,APIInstance: AnsiString; PrimaryEmail:AnsiString; Var sid,gid:AnsiString;PrimaryGroupOnly:Boolean = False):Boolean;
    Function GetResultFieldsResultLines(Var FResult: AnsiString; out Fields: THeaderIndexList; KeepHeaderLine: Boolean = False): Boolean;
    Function GetFieldResult(Const FResult: AnsiString; FField: AnsiString; Const Fields: THeaderIndexList): AnsiString;

Const
  SIV_TRIM = $01;
  SIV_NOTRIM = $02;
  SIV_NOVALUETRIM = $04;
  SIV_REST = $08;
  SIV_DELIMTRIM = $10;

  cSpace = AnsiChar(' ');
  cLF = AnsiChar(#$0A);
  cAnd = AnsiChar('&');
  cCRLF = AnsiString(#$0D#$0A);
  cPercent = AnsiChar('%');
  cPlus = AnsiChar('+');





implementation


Function CallAPI(P1,P2,P3:AnsiString;P4 : AnsiString='';P5 : AnsiString='';P6 : AnsiString='';P7 : AnsiString=''):AnsiString;
Var APIPtr:PAnsiChar;
Begin
  Result:='';

  if ((@globalAPICall<>Nil) And (@gAPIFree<>Nil)) Then
  Begin
     APIPtr := globalAPICall(PAnsiChar(P1),PAnsiChar(P2), PAnsiChar(P3),PAnsiChar(P4), PAnsiChar(P5), PAnsiChar(P6), PAnsiChar(P7));

     If APIPtr<>Nil Then
     Begin
       Result:=AnsiString(APIPtr);
       gAPIFree(APIPtr);
     End;
  End;

End;

Procedure APIDone;
Begin
  If gAPIDll<>0 Then
    FreeLibrary(gAPIDll);
End;

Function APIInit: Boolean;
{$IFNDEF LINUX}
  {$IFNDEF CPUX64}
    Const APILib='api.dll';
  {$ELSE}
    Const APILib='api_64.dll';
  {$ENDIF}

{$ELSE}
Const APILib='libapi.so';
{$ENDIF}
Begin
  Result:=False;

  // Initialize the IceWarp API so that logging functionality from API can be used
  gAPIDll:=LoadLibrary(APILib);

  If( gAPIDll<>0) Then
  Begin
    @globalAPICall:=GetProcAddress(gAPIDll,'icewarp_apiobjectcall');
    @gAPIFree:=GetProcAddress(gAPIDll,'icewarp_freeresult');


    Result:= (@globalAPICall<>Nil) And (@gAPIFree<>Nil);
  End;

End;

Function GWLoginAs(GWInstance,APIInstance: AnsiString; PrimaryEmail:AnsiString; Var sid,gid:AnsiString;PrimaryGroupOnly:Boolean = False):Boolean;
Var
  GWRes:AnsiString;
  GWSuperUser, GWSuperPass: AnsiString;
Begin
  Result:=True;

  GWSuperUser:=CallAPI(APIInstance,'GetProperty','C_GW_SuperUser');
  GWSuperPass:=CallAPI(APIInstance,'GetProperty','C_GW_SuperPass');


  If Result Then
  Begin
    sid:=CallAPI(GWInstance,'FunctionCall','loginuser',GWSuperUser,GWSuperPass);
    Result:=Length(sid)>0;
  End;

  If Result Then
  Begin
    GWRes:=CallAPI(GWInstance,'FunctionCall','substituteuser',sid,PrimaryEmail);
    Result:=GWRes='1';
  End;


  If Result Then
  Begin
    If Not PrimaryGroupOnly Then
      gid:=CallAPI(GWInstance,'FunctionCall','opengroup',sid,'*')
    Else
      gid:=CallAPI(GWInstance,'FunctionCall','opengroup',sid,'');

    Result:= Length(gid)>0;
  End;

End;

Function CopyIndex(const S: AnsiString; StartIndex, EndIndex: NativeInt): AnsiString;
Begin
  Result := Copy(S, StartIndex, EndIndex - StartIndex + $01);
End;

Function ATrim(S: AnsiString): AnsiString;
Begin
  Result := AnsiString(Trim(String(S)));
End;

Function ALowerCase(s: AnsiString): AnsiString;
Begin
  Result := AnsiString(LowerCase(String(S)));
End;


Function StrIndexVar(var S: AnsiString; Index: NativeInt; Delimiter: AnsiChar = cSpace; Flags: Longint = 0): AnsiString;
Var
  FIndex, FL, FI, I: NativeInt;
  Trim_, Rest, NoTrim, NoValueTrim, DelimTrim: Boolean;
Begin
  // Result
  Result := '';
  If Length(S) = $00 Then Exit;

  Rest := Flags And SIV_REST <> 0;
  Trim_ := Flags And SIV_TRIM <> 0;
  NoTrim := Flags And SIV_NOTRIM <> 0;
  NoValueTrim := Flags And SIV_NOVALUETRIM <> 0;
  DelimTrim := Flags And SIV_DELIMTRIM <> 0;

  // Trim
  If Trim_ Then
    While True Do
    Begin
      FI := Pos(Delimiter + Delimiter, S);
      If FI = $00 Then Break;
      Delete(S, FI, $01);
    End;

  // Prepare
  If Not NoTrim Then S :=  ATrim(S);

  // Exit
  If Length(S) = $00 Then Exit;

  // Prepare
  FIndex := $00;
  FL := $01;
  I := -$01;

  // For every char
  For FI := $01 To Length(S) Do
    // Delimiter
    If S[FI] = Delimiter Then
    Begin
      // Index
      If FIndex = Index Then
      Begin
        I := FI - $01;
        Break;
      End;

      FL := FI + $01;

      // Do not increment FIndex if previous delimiter is the same (similar as Trim_ but does not trim the delimiters and the value)
      If DelimTrim And (FI > 1) And (S[FI - 1] = Delimiter) Then Continue;

      Inc(FIndex);
    End;

  // Index - Return
  If FIndex = Index Then

    // Item
    If Not Rest Then
    Begin
      // Set end of string
      If I = -$01 Then I := Length(S);

      If Not NoValueTrim Then
        Result := ATrim(CopyIndex(S, FL, I))
      Else
        Result := CopyIndex(S, FL, I)
    End

    // Rest item
    Else
      If Not NoValueTrim Then
        Result := ATrim(CopyIndex(S, FL, Length(S)))
      Else
        Result := CopyIndex(S, FL, Length(S));
End;

Function StrIndex(S: AnsiString; Index: NativeInt; Delimiter: AnsiChar; Rest: Boolean = False; NoTrim: Boolean = False; NoValueTrim: Boolean = False; DefaultFlags: Integer = 0): AnsiString;
Var
  Flags: Integer;
Begin
  Flags := DefaultFlags;
  If Rest Then Flags := Flags Or SIV_REST;
  If NoTrim Then Flags := Flags Or SIV_NOTRIM;
  If NoValueTrim Then Flags := Flags Or SIV_NOVALUETRIM;

  Result := StrIndexVar(S, Index, Delimiter, Flags);
End;


Procedure GetResultFields(FResult: AnsiString; out Fields: THeaderIndexList);
Var
  S: AnsiString;
  FI: NativeInt;
Begin
  SetLength(Fields, $00);

  FResult := StrIndex(FResult, $00, cLF) + cAnd;

  While True Do
  Begin
    S := StrIndex(FResult, $00, cAnd);
    Delete(FResult, $01, Pos(cAnd, FResult));
    If Length(S) = $00 Then Break;

    FI := Length(Fields);
    SetLength(Fields, FI + $01);
    Fields[FI].Header := ALowerCase(S);
    Fields[FI].Index := FI;
  End;
End;

Procedure GetResultLines(Var FResult: AnsiString; CRLF: Boolean = True);
Var
  FI: NativeInt;
Begin
  FI := Pos(cLF, FResult);
  If FI = $00 Then FResult := '' Else Delete(FResult, $01, FI);

  If CRLF Then If Length(FResult) > $00 Then If FResult[Length(FResult)] <> cLF Then FResult := FResult + cCRLF;
End;


Function GetFieldIndex(FField: AnsiString; Const Fields: THeaderIndexList): Longint;
Var
  FI: NativeInt;
Begin
  Result := -1;

  FField := ALowerCase(FField);
  For FI := $00 To High(Fields) Do
    If Fields[FI].Header = FField Then
    Begin
      Result := FI;
      Break;
    End;
End;

Function URLDecode(const S: AnsiString; NoPlus: Boolean = False): AnsiString;
var
  Idx: Integer;   // loops thru chars in string
  Hex: AnsiString;    // string of hex characters
  Code: Integer;  // hex character code (-1 on error)
  WS: WideString;
begin
  // Intialise result and string index
  Result := '';
  Idx := 1;
  WS := '';

  // Loop thru string decoding each character
  while Idx <= Length(S) do
  begin
    case S[Idx] of
      cPercent:
      begin
        // % should be followed by two hex digits - exception otherwise
        if Idx <= Length(S) - 2 then
        begin
          // Ordinary hex
          If S[Idx+1] <> 'u' Then
          Begin
            // there are sufficient digits - try to decode hex digits
            Hex := S[Idx+1] + S[Idx+2];

            Code := SysUtils.StrToIntDef('$' + String(Hex), -1);

            // check for error and keep %
            if Code = -1 then
              Result := Result + cPercent
            else
            begin
              Inc(Idx, 2);

              // add character to result
              Result := Result + AnsiChar(Code);
            end;
          end
          else

          // Unicode hex
          if Idx <= Length(S) - 5 then
          begin
            // there are sufficient digits - try to decode hex digits
            Hex := S[Idx+2] + S[Idx+3] + S[Idx+4] + S[Idx+5];

            Code := SysUtils.StrToIntDef('$' + String(Hex), -1);

            // check for error and keep %
            if Code = -1 then
              Result := Result + cPercent
            else
            begin
              Inc(Idx, 5);

              // Add widechar
              If Length(WS) <> 1 Then SetLength(WS, 1);
              WS[1] := WideChar(Code);

              // add wide character to result as utf8
              Result := Result + System.UTF8Encode(WS);
            end;
          end;
        end
        else
          // insufficient digits - keep %
          Result := Result + cPercent
      end
      else
      begin
        // NoPlus + handling
        If (Not NoPlus) And (S[Idx] = cPlus) Then
          Result := Result + cSpace
        Else
          // All other characters pass thru unchanged
          Result := Result + S[Idx];
      end
    end;
    Inc(Idx);
  end;
end;


Function GetFieldResult(Const FResult: AnsiString; FField: AnsiString; Const Fields: THeaderIndexList): AnsiString;
Var
  FI: NativeInt;
Begin
  FI := GetFieldIndex(FField, Fields);
  if FI <> -1 then
    Result := URLDecode(StrIndex(FResult, FI, cAnd))
  else
    Result := '';
End;


Function GetResultFieldsResultLines(Var FResult: AnsiString; out Fields: THeaderIndexList; KeepHeaderLine: Boolean = False): Boolean;
Begin
  GetResultFields(FResult, Fields);
  If Not KeepHeaderLine Then GetResultLines(FResult);

  Result := Length(Fields) > $00;
End;



end.

