/* IceWarp Merak Mail Server
 * (c) IceWarp Ltd. 2009, 2010
 *
 *       All rights reserved.
 *
 * http://www.icewarp.com
 *
 * file: icewarp_api.h - IceWarp API header file
 * version: 1.1
 */

/* Use this header file to call functions from file api.dll on Windows or libapi.so on Linux. */

#ifndef __ICEWARP_API_H__
#define __ICEWARP_API_H__ 1

#ifdef __cplusplus
extern "C" {
#endif

/* Calling function icewarp_apiobjectcall() is same as in PHP API.
 * Please see file classes.txt for available objects and methods.
 */

char *icewarp_apiobjectcall(const char *_Object,
                            const char *_Method,
                            const char *Parameter1,
                            const char *Parameter2,
                            const char *Parameter3,
                            const char *Parameter4,
                            const char *Parameter5);

/* Function icewarp_apiobjectcall_persistent() offers the same
 * functionality as icewarp_apiobjectcall, except that API call
 * is not executed in context of calling process, but it is serviced
 * by control. Therefore running control is a must for this function.
 */

char *icewarp_apiobjectcall_persistent(const char *_Object,
                                       const char *_Method,
                                       const char *Parameter1,
                                       const char *Parameter2,
                                       const char *Parameter3,
                                       const char *Parameter4,
                                       const char *Parameter5);
                           
/* Function must be called to free every result
 * returned from icewarp_apiobjectcall()
 */
 
void icewarp_freeresult(void *_Result);

void init_API();
void done_API();


#ifdef __cplusplus
}
#endif

#endif /* __ICEWARP_API_H__ */
