using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Icewarp.XmlRpcExample.Utils;
using Icewarp.XmlRpcExample.XmlRpc.Base;

// IceWarp


namespace Icewarp.ExchangeMigratorLib.Com
{
	/// <summary>
	/// Class for creating domains on Merak
	/// </summary>
	public class IceWarpDomain : IceWarpXmlRpc
	{
		#region Fields
		private Logger.Helper m_log = new Logger.Helper("IceWarpDomain");
		#endregion // Fields

		#region Ctor
		/// <summary>
		/// Ctor
		/// </summary>
		/// <param name="isRemote"></param>
		public IceWarpDomain(LoginCredentials credentials)
			: base(credentials)
		{
			CreateDomainComConnection();
		}
		#endregion // Ctor

		#region Public methods
		/// <summary>
		/// Creates domain
		/// </summary>
		/// <param name="domain"></param>
		/// <returns></returns>
		//public bool CreateDomain(string domain)
		//{
		//    bool created = false;

		//    object result = MethodInvoker("Open", new string[] { domain, "", "", "" });

		//    if (result != null)
		//    {
		//        bool exists = ((string)result).Equals("1");

		//        if (!exists)
		//        {
		//            m_log.WriteDebugLog(String.Format("Creating domain {0}", domain));

		//            MethodInvoker("New", new string[] { domain });
		//            MethodInvoker("SetProperty", new string[] { "D_Type", "0" });
		//            MethodInvoker("SetProperty", new string[] { "D_DomainValue", domain });
		//            created = (MethodInvoker("Save", null) != null);
		//        }
		//        else
		//        {
		//            m_log.WriteDebugLog(String.Format("Domain {0} already exists", domain));
		//            created = true;
		//        }
		//    }

		//    return created;
		//}


		public string OpenDomain(string domain)
		{
			return MethodInvoker("Open", new string[] { domain }) as string;
		}

		public string GetAccountIndexByAlias(string alias)
		{
			return MethodInvoker("GetAccountIndexByAlias", new string[] { alias }) as string;
		}
		#endregion // Public methods

		#region Private methods
		/// <summary>
		/// Initializes COM object to IceWarpServer.DomainObject
		/// </summary>
		/// <returns></returns>
		private bool CreateDomainComConnection()
		{
			return CreateComConnection("IceWarpServer.DomainObject");
		}
		#endregion // Private methods
	}
}
