/*																	*
 * This file is a part of an example of how to communicate			*
 * with IceWarp Unified Messaging server using XML-RPC				*
 *																	*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.				*
 *																	*
 * IceWarp Ltd 2011													*
 *																	*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Icewarp.XmlRpcExample.Utils
{
    public class LoginCredentials
    {
        #region Fields
        private string m_username;
        #endregion // Fields

        #region Properties
        /// <summary>
        /// Accoutn username
        /// </summary>
        public string Username
        {
            get
            {
                string username;
                if (LoginWithFullAddress)
                {
                    username = String.Format("{0}@{1}", m_username, Domain);
                }
                else
                {
                    username = m_username;
                }

                return username;
            }
        }

        /// <summary>
        /// Account password
        /// </summary>
        public string Password { get; private set; }
        /// <summary>
        /// Account domain
        /// </summary>
        public string Domain { get; private set; }
        /// <summary>
        /// If true entire address will be used for login,
        /// if false then username only will be used
        /// </summary>
        public bool LoginWithFullAddress { get; private set; }
        /// <summary>
        /// Hostname of the destination server
        /// </summary>
        public string Hostname { get; private set; }
        /// <summary>
        /// Control port of the web service on Merak
        /// </summary>
        public int ControlPort { get; private set; }
        #endregion // Properties

        #region Ctor
        /// <summary>
        /// Ctor
        /// </summary>
        /// <param name="username">Account username</param>
        /// <param name="domain">Account domain</param>
        /// <param name="password">Account password</param>
        /// <param name="loginWithEmail">Determines the shape of the username</param>
        /// <param name="hostname">Hostname of the destination server</param>
        /// <param name="controlPort">Control port of the Merak web service</param>
        public LoginCredentials(string username, string domain, string password, bool loginWithEmail, string hostname, int controlPort)
        {
            m_username = username;
            Domain = domain;
            Password = password;
            Hostname = hostname;
            ControlPort = controlPort;
            LoginWithFullAddress = loginWithEmail;
        }
        #endregion // Ctor
    }
}
